<?php
/**
 * Copyright © OXID eSales AG. All rights reserved.
 * See LICENSE file for license details.
 */

/**
 * @internal Do not make a module extension based on this file.
 * @see      https://oxidforge.org/en/core-oxid-eshop-classes-must-not-be-extended.html
 */
return [
    'oxcmp_basket'                        => 'OxidEsales\\Eshop\\Application\\Component\\BasketComponent',
    'oxcmp_categories'                    => 'OxidEsales\\Eshop\\Application\\Component\\CategoriesComponent',
    'oxcmp_cur'                           => 'OxidEsales\\Eshop\\Application\\Component\\CurrencyComponent',
    'oxcmp_lang'                          => 'OxidEsales\\Eshop\\Application\\Component\\LanguageComponent',
    'oxlocator'                           => 'OxidEsales\\Eshop\\Application\\Component\\Locator',
    'oxcmp_news'                          => 'OxidEsales\\Eshop\\Application\\Component\\NewsComponent',
    'oxelement2shoprelationsservice'      => 'OxidEsales\\Eshop\\Application\\Component\\Service\\Element2ShopRelationsService',
    'oxcmp_shop'                          => 'OxidEsales\\Eshop\\Application\\Component\\ShopComponent',
    'oxcmp_user'                          => 'OxidEsales\\Eshop\\Application\\Component\\UserComponent',
    'oxcmp_utils'                         => 'OxidEsales\\Eshop\\Application\\Component\\UtilsComponent',
    'oxwactions'                          => 'OxidEsales\\Eshop\\Application\\Component\\Widget\\Actions',
    'oxwarticlebox'                       => 'OxidEsales\\Eshop\\Application\\Component\\Widget\\ArticleBox',
    'oxwarticledetails'                   => 'OxidEsales\\Eshop\\Application\\Component\\Widget\\ArticleDetails',
    'oxwbetanote'                         => 'OxidEsales\\Eshop\\Application\\Component\\Widget\\BetaNote',
    'oxwcategorytree'                     => 'OxidEsales\\Eshop\\Application\\Component\\Widget\\CategoryTree',
    'oxwcookienote'                       => 'OxidEsales\\Eshop\\Application\\Component\\Widget\\CookieNote',
    'oxwcurrencylist'                     => 'OxidEsales\\Eshop\\Application\\Component\\Widget\\CurrencyList',
    'oxwinformation'                      => 'OxidEsales\\Eshop\\Application\\Component\\Widget\\Information',
    'oxwlanguagelist'                     => 'OxidEsales\\Eshop\\Application\\Component\\Widget\\LanguageList',
    'oxwmanufacturerlist'                 => 'OxidEsales\\Eshop\\Application\\Component\\Widget\\ManufacturerList',
    'oxwminibasket'                       => 'OxidEsales\\Eshop\\Application\\Component\\Widget\\MiniBasket',
    'oxwrating'                           => 'OxidEsales\\Eshop\\Application\\Component\\Widget\\Rating',
    'oxwrecommendation'                   => 'OxidEsales\\Eshop\\Application\\Component\\Widget\\Recommendation',
    'oxwreview'                           => 'OxidEsales\\Eshop\\Application\\Component\\Widget\\Review',
    'oxwservicelist'                      => 'OxidEsales\\Eshop\\Application\\Component\\Widget\\ServiceList',
    'oxwservicemenu'                      => 'OxidEsales\\Eshop\\Application\\Component\\Widget\\ServiceMenu',
    'oxwvendorlist'                       => 'OxidEsales\\Eshop\\Application\\Component\\Widget\\VendorList',
    'oxwidget'                            => 'OxidEsales\\Eshop\\Application\\Component\\Widget\\WidgetController',
    'account'                             => 'OxidEsales\\Eshop\\Application\\Controller\\AccountController',
    'account_downloads'                   => 'OxidEsales\\Eshop\\Application\\Controller\\AccountDownloadsController',
    'account_newsletter'                  => 'OxidEsales\\Eshop\\Application\\Controller\\AccountNewsletterController',
    'account_noticelist'                  => 'OxidEsales\\Eshop\\Application\\Controller\\AccountNoticeListController',
    'account_order'                       => 'OxidEsales\\Eshop\\Application\\Controller\\AccountOrderController',
    'account_password'                    => 'OxidEsales\\Eshop\\Application\\Controller\\AccountPasswordController',
    'account_recommlist'                  => 'OxidEsales\\Eshop\\Application\\Controller\\AccountRecommlistController',
    'account_user'                        => 'OxidEsales\\Eshop\\Application\\Controller\\AccountUserController',
    'account_wishlist'                    => 'OxidEsales\\Eshop\\Application\\Controller\\AccountWishlistController',
    'actions_article_ajax'                => 'OxidEsales\\Eshop\\Application\\Controller\\Admin\\ActionsArticleAjax',
    'actions'                             => 'OxidEsales\\Eshop\\Application\\Controller\\Admin\\ActionsController',
    'actions_groups_ajax'                 => 'OxidEsales\\Eshop\\Application\\Controller\\Admin\\ActionsGroupsAjax',
    'actions_list'                        => 'OxidEsales\\Eshop\\Application\\Controller\\Admin\\ActionsList',
    'actions_main'                        => 'OxidEsales\\Eshop\\Application\\Controller\\Admin\\ActionsMain',
    'actions_main_ajax'                   => 'OxidEsales\\Eshop\\Application\\Controller\\Admin\\ActionsMainAjax',
    'actions_order_ajax'                  => 'OxidEsales\\Eshop\\Application\\Controller\\Admin\\ActionsOrderAjax',
    'admin_beroles'                       => 'OxidEsales\\Eshop\\Application\\Controller\\Admin\\AdminBackEndRoles',
    'admin_content'                       => 'OxidEsales\\Eshop\\Application\\Controller\\Admin\\AdminContent',
    'oxadminview'                         => 'OxidEsales\\Eshop\\Application\\Controller\\Admin\\AdminController',
    'oxadmindetails'                      => 'OxidEsales\\Eshop\\Application\\Controller\\Admin\\AdminDetailsController',
    'admin_feroles'                       => 'OxidEsales\\Eshop\\Application\\Controller\\Admin\\AdminFrontEndRoles',
    'admin_links'                         => 'OxidEsales\\Eshop\\Application\\Controller\\Admin\\AdminLinks',
    'adminlinks_mall'                     => 'OxidEsales\\Eshop\\Application\\Controller\\Admin\\AdminLinksMall',
    'oxadminlist'                         => 'OxidEsales\\Eshop\\Application\\Controller\\Admin\\AdminListController',
    'admin_mall'                          => 'OxidEsales\\Eshop\\Application\\Controller\\Admin\\AdminMall',
    'admin_news'                          => 'OxidEsales\\Eshop\\Application\\Controller\\Admin\\AdminNews',
    'admin_newsletter'                    => 'OxidEsales\\Eshop\\Application\\Controller\\Admin\\AdminNewsletter',
    'admin_order'                         => 'OxidEsales\\Eshop\\Application\\Controller\\Admin\\AdminOrder',
    'admin_payment'                       => 'OxidEsales\\Eshop\\Application\\Controller\\Admin\\AdminPayment',
    'admin_pricealarm'                    => 'OxidEsales\\Eshop\\Application\\Controller\\Admin\\AdminPriceAlarm',
    'admin_start'                         => 'OxidEsales\\Eshop\\Application\\Controller\\Admin\\AdminStart',
    'admin_user'                          => 'OxidEsales\\Eshop\\Application\\Controller\\Admin\\AdminUser',
    'admin_wrapping'                      => 'OxidEsales\\Eshop\\Application\\Controller\\Admin\\AdminWrapping',
    'adminlinks_list'                     => 'OxidEsales\\Eshop\\Application\\Controller\\Admin\\AdminlinksList',
    'adminlinks_main'                     => 'OxidEsales\\Eshop\\Application\\Controller\\Admin\\AdminlinksMain',
    'article_accessories_ajax'            => 'OxidEsales\\Eshop\\Application\\Controller\\Admin\\ArticleAccessoriesAjax',
    'article_attribute'                   => 'OxidEsales\\Eshop\\Application\\Controller\\Admin\\ArticleAttribute',
    'article_attribute_ajax'              => 'OxidEsales\\Eshop\\Application\\Controller\\Admin\\ArticleAttributeAjax',
    'article_bundle_ajax'                 => 'OxidEsales\\Eshop\\Application\\Controller\\Admin\\ArticleBundleAjax',
    'article'                             => 'OxidEsales\\Eshop\\Application\\Controller\\Admin\\ArticleController',
    'article_crossselling'                => 'OxidEsales\\Eshop\\Application\\Controller\\Admin\\ArticleCrossselling',
    'article_crossselling_ajax'           => 'OxidEsales\\Eshop\\Application\\Controller\\Admin\\ArticleCrosssellingAjax',
    'article_extend'                      => 'OxidEsales\\Eshop\\Application\\Controller\\Admin\\ArticleExtend',
    'article_extend_ajax'                 => 'OxidEsales\\Eshop\\Application\\Controller\\Admin\\ArticleExtendAjax',
    'article_files'                       => 'OxidEsales\\Eshop\\Application\\Controller\\Admin\\ArticleFiles',
    'article_list'                        => 'OxidEsales\\Eshop\\Application\\Controller\\Admin\\ArticleList',
    'article_main'                        => 'OxidEsales\\Eshop\\Application\\Controller\\Admin\\ArticleMain',
    'article_mall'                        => 'OxidEsales\\Eshop\\Application\\Controller\\Admin\\ArticleMall',
    'article_overview'                    => 'OxidEsales\\Eshop\\Application\\Controller\\Admin\\ArticleOverview',
    'article_pictures'                    => 'OxidEsales\\Eshop\\Application\\Controller\\Admin\\ArticlePictures',
    'article_review'                      => 'OxidEsales\\Eshop\\Application\\Controller\\Admin\\ArticleReview',
    'article_rights'                      => 'OxidEsales\\Eshop\\Application\\Controller\\Admin\\ArticleRights',
    'article_rights_buyable_ajax'         => 'OxidEsales\\Eshop\\Application\\Controller\\Admin\\ArticleRightsBuyableAjax',
    'article_rights_visible_ajax'         => 'OxidEsales\\Eshop\\Application\\Controller\\Admin\\ArticleRightsVisibleAjax',
    'article_selection_ajax'              => 'OxidEsales\\Eshop\\Application\\Controller\\Admin\\ArticleSelectionAjax',
    'article_seo'                         => 'OxidEsales\\Eshop\\Application\\Controller\\Admin\\ArticleSeo',
    'article_stock'                       => 'OxidEsales\\Eshop\\Application\\Controller\\Admin\\ArticleStock',
    'article_userdef'                     => 'OxidEsales\\Eshop\\Application\\Controller\\Admin\\ArticleUserdef',
    'article_variant'                     => 'OxidEsales\\Eshop\\Application\\Controller\\Admin\\ArticleVariant',
    'attribute_category'                  => 'OxidEsales\\Eshop\\Application\\Controller\\Admin\\AttributeCategory',
    'attribute_category_ajax'             => 'OxidEsales\\Eshop\\Application\\Controller\\Admin\\AttributeCategoryAjax',
    'attribute'                           => 'OxidEsales\\Eshop\\Application\\Controller\\Admin\\AttributeController',
    'attribute_list'                      => 'OxidEsales\\Eshop\\Application\\Controller\\Admin\\AttributeList',
    'attribute_main'                      => 'OxidEsales\\Eshop\\Application\\Controller\\Admin\\AttributeMain',
    'attribute_main_ajax'                 => 'OxidEsales\\Eshop\\Application\\Controller\\Admin\\AttributeMainAjax',
    'attribute_mall'                      => 'OxidEsales\\Eshop\\Application\\Controller\\Admin\\AttributeMall',
    'attribute_order_ajax'                => 'OxidEsales\\Eshop\\Application\\Controller\\Admin\\AttributeOrderAjax',
    'category'                            => 'OxidEsales\\Eshop\\Application\\Controller\\Admin\\CategoryController',
    'category_list'                       => 'OxidEsales\\Eshop\\Application\\Controller\\Admin\\CategoryList',
    'category_main'                       => 'OxidEsales\\Eshop\\Application\\Controller\\Admin\\CategoryMain',
    'category_main_ajax'                  => 'OxidEsales\\Eshop\\Application\\Controller\\Admin\\CategoryMainAjax',
    'category_mall'                       => 'OxidEsales\\Eshop\\Application\\Controller\\Admin\\CategoryMall',
    'category_order'                      => 'OxidEsales\\Eshop\\Application\\Controller\\Admin\\CategoryOrder',
    'category_order_ajax'                 => 'OxidEsales\\Eshop\\Application\\Controller\\Admin\\CategoryOrderAjax',
    'category_pictures'                   => 'OxidEsales\\Eshop\\Application\\Controller\\Admin\\CategoryPictures',
    'category_rights'                     => 'OxidEsales\\Eshop\\Application\\Controller\\Admin\\CategoryRights',
    'category_rights_buyable_ajax'        => 'OxidEsales\\Eshop\\Application\\Controller\\Admin\\CategoryRightsBuyableAjax',
    'category_rights_visible_ajax'        => 'OxidEsales\\Eshop\\Application\\Controller\\Admin\\CategoryRightsVisibleAjax',
    'category_seo'                        => 'OxidEsales\\Eshop\\Application\\Controller\\Admin\\CategorySeo',
    'category_text'                       => 'OxidEsales\\Eshop\\Application\\Controller\\Admin\\CategoryText',
    'category_update'                     => 'OxidEsales\\Eshop\\Application\\Controller\\Admin\\CategoryUpdate',
    'content_list'                        => 'OxidEsales\\Eshop\\Application\\Controller\\Admin\\ContentList',
    'content_main'                        => 'OxidEsales\\Eshop\\Application\\Controller\\Admin\\ContentMain',
    'content_seo'                         => 'OxidEsales\\Eshop\\Application\\Controller\\Admin\\ContentSeo',
    'country'                             => 'OxidEsales\\Eshop\\Application\\Controller\\Admin\\CountryController',
    'country_list'                        => 'OxidEsales\\Eshop\\Application\\Controller\\Admin\\CountryList',
    'country_main'                        => 'OxidEsales\\Eshop\\Application\\Controller\\Admin\\CountryMain',
    'delivery_articles'                   => 'OxidEsales\\Eshop\\Application\\Controller\\Admin\\DeliveryArticles',
    'delivery_articles_ajax'              => 'OxidEsales\\Eshop\\Application\\Controller\\Admin\\DeliveryArticlesAjax',
    'delivery_categories_ajax'            => 'OxidEsales\\Eshop\\Application\\Controller\\Admin\\DeliveryCategoriesAjax',
    'delivery'                            => 'OxidEsales\\Eshop\\Application\\Controller\\Admin\\DeliveryController',
    'delivery_groups_ajax'                => 'OxidEsales\\Eshop\\Application\\Controller\\Admin\\DeliveryGroupsAjax',
    'delivery_list'                       => 'OxidEsales\\Eshop\\Application\\Controller\\Admin\\DeliveryList',
    'delivery_main'                       => 'OxidEsales\\Eshop\\Application\\Controller\\Admin\\DeliveryMain',
    'delivery_main_ajax'                  => 'OxidEsales\\Eshop\\Application\\Controller\\Admin\\DeliveryMainAjax',
    'delivery_mall'                       => 'OxidEsales\\Eshop\\Application\\Controller\\Admin\\DeliveryMall',
    'deliveryset'                         => 'OxidEsales\\Eshop\\Application\\Controller\\Admin\\DeliverySetController',
    'deliveryset_country_ajax'            => 'OxidEsales\\Eshop\\Application\\Controller\\Admin\\DeliverySetCountryAjax',
    'deliveryset_groups_ajax'             => 'OxidEsales\\Eshop\\Application\\Controller\\Admin\\DeliverySetGroupsAjax',
    'deliveryset_list'                    => 'OxidEsales\\Eshop\\Application\\Controller\\Admin\\DeliverySetList',
    'deliveryset_main'                    => 'OxidEsales\\Eshop\\Application\\Controller\\Admin\\DeliverySetMain',
    'deliveryset_main_ajax'               => 'OxidEsales\\Eshop\\Application\\Controller\\Admin\\DeliverySetMainAjax',
    'deliveryset_mall'                    => 'OxidEsales\\Eshop\\Application\\Controller\\Admin\\DeliverySetMall',
    'deliveryset_payment'                 => 'OxidEsales\\Eshop\\Application\\Controller\\Admin\\DeliverySetPayment',
    'deliveryset_payment_ajax'            => 'OxidEsales\\Eshop\\Application\\Controller\\Admin\\DeliverySetPaymentAjax',
    'deliveryset_rdfa'                    => 'OxidEsales\\Eshop\\Application\\Controller\\Admin\\DeliverySetRdfa',
    'deliveryset_users'                   => 'OxidEsales\\Eshop\\Application\\Controller\\Admin\\DeliverySetUsers',
    'deliveryset_users_ajax'              => 'OxidEsales\\Eshop\\Application\\Controller\\Admin\\DeliverySetUsersAjax',
    'delivery_users'                      => 'OxidEsales\\Eshop\\Application\\Controller\\Admin\\DeliveryUsers',
    'delivery_users_ajax'                 => 'OxidEsales\\Eshop\\Application\\Controller\\Admin\\DeliveryUsersAjax',
    'diagnostics'                         => 'OxidEsales\\Eshop\\Application\\Controller\\Admin\\DiagnosticsController',
    'diagnostics_list'                    => 'OxidEsales\\Eshop\\Application\\Controller\\Admin\\DiagnosticsList',
    'diagnostics_main'                    => 'OxidEsales\\Eshop\\Application\\Controller\\Admin\\DiagnosticsMain',
    'discount_articles'                   => 'OxidEsales\\Eshop\\Application\\Controller\\Admin\\DiscountArticles',
    'discount_articles_ajax'              => 'OxidEsales\\Eshop\\Application\\Controller\\Admin\\DiscountArticlesAjax',
    'discount_categories_ajax'            => 'OxidEsales\\Eshop\\Application\\Controller\\Admin\\DiscountCategoriesAjax',
    'discount'                            => 'OxidEsales\\Eshop\\Application\\Controller\\Admin\\DiscountController',
    'discount_groups_ajax'                => 'OxidEsales\\Eshop\\Application\\Controller\\Admin\\DiscountGroupsAjax',
    'discount_item_ajax'                  => 'OxidEsales\\Eshop\\Application\\Controller\\Admin\\DiscountItemAjax',
    'discount_list'                       => 'OxidEsales\\Eshop\\Application\\Controller\\Admin\\DiscountList',
    'discount_main'                       => 'OxidEsales\\Eshop\\Application\\Controller\\Admin\\DiscountMain',
    'discount_main_ajax'                  => 'OxidEsales\\Eshop\\Application\\Controller\\Admin\\DiscountMainAjax',
    'discount_mall'                       => 'OxidEsales\\Eshop\\Application\\Controller\\Admin\\DiscountMall',
    'discount_users'                      => 'OxidEsales\\Eshop\\Application\\Controller\\Admin\\DiscountUsers',
    'discount_users_ajax'                 => 'OxidEsales\\Eshop\\Application\\Controller\\Admin\\DiscountUsersAjax',
    'dyn_econda'                          => 'OxidEsales\\Eshop\\Application\\Controller\\Admin\\DynEconda',
    'dynexportbase'                       => 'OxidEsales\\Eshop\\Application\\Controller\\Admin\\DynamicExportBaseController',
    'dyn_interface'                       => 'OxidEsales\\Eshop\\Application\\Controller\\Admin\\DynamicInterface',
    'dynscreen'                           => 'OxidEsales\\Eshop\\Application\\Controller\\Admin\\DynamicScreenController',
    'dynscreen_list'                      => 'OxidEsales\\Eshop\\Application\\Controller\\Admin\\DynamicScreenList',
    'dynscreen_local'                     => 'OxidEsales\\Eshop\\Application\\Controller\\Admin\\DynamicScreenLocal',
    'genexport'                           => 'OxidEsales\\Eshop\\Application\\Controller\\Admin\\GenericExport',
    'genexport_do'                        => 'OxidEsales\\Eshop\\Application\\Controller\\Admin\\GenericExportDo',
    'genexport_main'                      => 'OxidEsales\\Eshop\\Application\\Controller\\Admin\\GenericExportMain',
    'genimport'                           => 'OxidEsales\\Eshop\\Application\\Controller\\Admin\\GenericImport',
    'genimport_main'                      => 'OxidEsales\\Eshop\\Application\\Controller\\Admin\\GenericImportMain',
    'language'                            => 'OxidEsales\\Eshop\\Application\\Controller\\Admin\\LanguageController',
    'language_list'                       => 'OxidEsales\\Eshop\\Application\\Controller\\Admin\\LanguageList',
    'language_main'                       => 'OxidEsales\\Eshop\\Application\\Controller\\Admin\\LanguageMain',
    'ajaxlistcomponent'                   => 'OxidEsales\\Eshop\\Application\\Controller\\Admin\\ListComponentAjax',
    'list_review'                         => 'OxidEsales\\Eshop\\Application\\Controller\\Admin\\ListReview',
    'list_user'                           => 'OxidEsales\\Eshop\\Application\\Controller\\Admin\\ListUser',
    'login'                               => 'OxidEsales\\Eshop\\Application\\Controller\\Admin\\LoginController',
    'manufacturer'                        => 'OxidEsales\\Eshop\\Application\\Controller\\Admin\\ManufacturerController',
    'manufacturer_list'                   => 'OxidEsales\\Eshop\\Application\\Controller\\Admin\\ManufacturerList',
    'manufacturer_main'                   => 'OxidEsales\\Eshop\\Application\\Controller\\Admin\\ManufacturerMain',
    'manufacturer_main_ajax'              => 'OxidEsales\\Eshop\\Application\\Controller\\Admin\\ManufacturerMainAjax',
    'manufacturer_mall'                   => 'OxidEsales\\Eshop\\Application\\Controller\\Admin\\ManufacturerMall',
    'manufacturer_seo'                    => 'OxidEsales\\Eshop\\Application\\Controller\\Admin\\ManufacturerSeo',
    'module_config'                       => 'OxidEsales\\Eshop\\Application\\Controller\\Admin\\ModuleConfiguration',
    'module'                              => 'OxidEsales\\Eshop\\Application\\Controller\\Admin\\ModuleController',
    'module_list'                         => 'OxidEsales\\Eshop\\Application\\Controller\\Admin\\ModuleList',
    'module_main'                         => 'OxidEsales\\Eshop\\Application\\Controller\\Admin\\ModuleMain',
    'module_sortlist'                     => 'OxidEsales\\Eshop\\Application\\Controller\\Admin\\ModuleSortList',
    'navigation'                          => 'OxidEsales\\Eshop\\Application\\Controller\\Admin\\NavigationController',
    'oxnavigationtree'                    => 'OxidEsales\\Eshop\\Application\\Controller\\Admin\\NavigationTree',
    'news_list'                           => 'OxidEsales\\Eshop\\Application\\Controller\\Admin\\NewsList',
    'news_main'                           => 'OxidEsales\\Eshop\\Application\\Controller\\Admin\\NewsMain',
    'news_main_ajax'                      => 'OxidEsales\\Eshop\\Application\\Controller\\Admin\\NewsMainAjax',
    'news_mall'                           => 'OxidEsales\\Eshop\\Application\\Controller\\Admin\\NewsMall',
    'news_text'                           => 'OxidEsales\\Eshop\\Application\\Controller\\Admin\\NewsText',
    'newsletter_list'                     => 'OxidEsales\\Eshop\\Application\\Controller\\Admin\\NewsletterList',
    'newsletter_main'                     => 'OxidEsales\\Eshop\\Application\\Controller\\Admin\\NewsletterMain',
    'newsletter_plain'                    => 'OxidEsales\\Eshop\\Application\\Controller\\Admin\\NewsletterPlain',
    'newsletter_preview'                  => 'OxidEsales\\Eshop\\Application\\Controller\\Admin\\NewsletterPreview',
    'newsletter_selection'                => 'OxidEsales\\Eshop\\Application\\Controller\\Admin\\NewsletterSelection',
    'newsletter_selection_ajax'           => 'OxidEsales\\Eshop\\Application\\Controller\\Admin\\NewsletterSelectionAjax',
    'newsletter_send'                     => 'OxidEsales\\Eshop\\Application\\Controller\\Admin\\NewsletterSend',
    'object_seo'                          => 'OxidEsales\\Eshop\\Application\\Controller\\Admin\\ObjectSeo',
    'order_address'                       => 'OxidEsales\\Eshop\\Application\\Controller\\Admin\\OrderAddress',
    'order_article'                       => 'OxidEsales\\Eshop\\Application\\Controller\\Admin\\OrderArticle',
    'order_downloads'                     => 'OxidEsales\\Eshop\\Application\\Controller\\Admin\\OrderDownloads',
    'order_list'                          => 'OxidEsales\\Eshop\\Application\\Controller\\Admin\\OrderList',
    'order_main'                          => 'OxidEsales\\Eshop\\Application\\Controller\\Admin\\OrderMain',
    'order_overview'                      => 'OxidEsales\\Eshop\\Application\\Controller\\Admin\\OrderOverview',
    'order_remark'                        => 'OxidEsales\\Eshop\\Application\\Controller\\Admin\\OrderRemark',
    'payment_country'                     => 'OxidEsales\\Eshop\\Application\\Controller\\Admin\\PaymentCountry',
    'payment_country_ajax'                => 'OxidEsales\\Eshop\\Application\\Controller\\Admin\\PaymentCountryAjax',
    'payment_list'                        => 'OxidEsales\\Eshop\\Application\\Controller\\Admin\\PaymentList',
    'payment_main'                        => 'OxidEsales\\Eshop\\Application\\Controller\\Admin\\PaymentMain',
    'payment_main_ajax'                   => 'OxidEsales\\Eshop\\Application\\Controller\\Admin\\PaymentMainAjax',
    'payment_rdfa'                        => 'OxidEsales\\Eshop\\Application\\Controller\\Admin\\PaymentRdfa',
    'pricealarm_list'                     => 'OxidEsales\\Eshop\\Application\\Controller\\Admin\\PriceAlarmList',
    'pricealarm_mail'                     => 'OxidEsales\\Eshop\\Application\\Controller\\Admin\\PriceAlarmMail',
    'pricealarm_main'                     => 'OxidEsales\\Eshop\\Application\\Controller\\Admin\\PriceAlarmMain',
    'pricealarm_send'                     => 'OxidEsales\\Eshop\\Application\\Controller\\Admin\\PriceAlarmSend',
    'roles_begroups_ajax'                 => 'OxidEsales\\Eshop\\Application\\Controller\\Admin\\RolesBackendGroupsAjax',
    'roles_belist'                        => 'OxidEsales\\Eshop\\Application\\Controller\\Admin\\RolesBackendList',
    'roles_bemain'                        => 'OxidEsales\\Eshop\\Application\\Controller\\Admin\\RolesBackendMain',
    'roles_beobject'                      => 'OxidEsales\\Eshop\\Application\\Controller\\Admin\\RolesBackendObject',
    'roles_beuser'                        => 'OxidEsales\\Eshop\\Application\\Controller\\Admin\\RolesBackendUser',
    'roles_beuser_ajax'                   => 'OxidEsales\\Eshop\\Application\\Controller\\Admin\\RolesBackendUserAjax',
    'roles_fegroups_ajax'                 => 'OxidEsales\\Eshop\\Application\\Controller\\Admin\\RolesFrontendGroupsAjax',
    'roles_felist'                        => 'OxidEsales\\Eshop\\Application\\Controller\\Admin\\RolesFrontendList',
    'roles_femain'                        => 'OxidEsales\\Eshop\\Application\\Controller\\Admin\\RolesFrontendMain',
    'roles_feuser'                        => 'OxidEsales\\Eshop\\Application\\Controller\\Admin\\RolesFrontendUser',
    'selectlist'                          => 'OxidEsales\\Eshop\\Application\\Controller\\Admin\\SelectListController',
    'selectlist_list'                     => 'OxidEsales\\Eshop\\Application\\Controller\\Admin\\SelectListList',
    'selectlist_main'                     => 'OxidEsales\\Eshop\\Application\\Controller\\Admin\\SelectListMain',
    'selectlist_main_ajax'                => 'OxidEsales\\Eshop\\Application\\Controller\\Admin\\SelectListMainAjax',
    'selectlist_mall'                     => 'OxidEsales\\Eshop\\Application\\Controller\\Admin\\SelectListMall',
    'selectlist_order_ajax'               => 'OxidEsales\\Eshop\\Application\\Controller\\Admin\\SelectListOrderAjax',
    'shop_cache'                          => 'OxidEsales\\Eshop\\Application\\Controller\\Admin\\ShopCache',
    'shop_config'                         => 'OxidEsales\\Eshop\\Application\\Controller\\Admin\\ShopConfiguration',
    'shop'                                => 'OxidEsales\\Eshop\\Application\\Controller\\Admin\\ShopController',
    'shop_default_category_ajax'          => 'OxidEsales\\Eshop\\Application\\Controller\\Admin\\ShopDefaultCategoryAjax',
    'shop_license'                        => 'OxidEsales\\Eshop\\Application\\Controller\\Admin\\ShopLicense',
    'shop_list'                           => 'OxidEsales\\Eshop\\Application\\Controller\\Admin\\ShopList',
    'shop_main'                           => 'OxidEsales\\Eshop\\Application\\Controller\\Admin\\ShopMain',
    'shop_mall'                           => 'OxidEsales\\Eshop\\Application\\Controller\\Admin\\ShopMall',
    'shop_performance'                    => 'OxidEsales\\Eshop\\Application\\Controller\\Admin\\ShopPerformance',
    'shop_rdfa'                           => 'OxidEsales\\Eshop\\Application\\Controller\\Admin\\ShopRdfa',
    'shop_seo'                            => 'OxidEsales\\Eshop\\Application\\Controller\\Admin\\ShopSeo',
    'shop_system'                         => 'OxidEsales\\Eshop\\Application\\Controller\\Admin\\ShopSystem',
    'systeminfo'                          => 'OxidEsales\\Eshop\\Application\\Controller\\Admin\\SystemInfoController',
    'sysreq'                              => 'OxidEsales\\Eshop\\Application\\Controller\\Admin\\SystemRequirements',
    'sysreq_list'                         => 'OxidEsales\\Eshop\\Application\\Controller\\Admin\\SystemRequirementsList',
    'sysreq_main'                         => 'OxidEsales\\Eshop\\Application\\Controller\\Admin\\SystemRequirementsMain',
    'theme_config'                        => 'OxidEsales\\Eshop\\Application\\Controller\\Admin\\ThemeConfiguration',
    'theme'                               => 'OxidEsales\\Eshop\\Application\\Controller\\Admin\\ThemeController',
    'theme_list'                          => 'OxidEsales\\Eshop\\Application\\Controller\\Admin\\ThemeList',
    'theme_main'                          => 'OxidEsales\\Eshop\\Application\\Controller\\Admin\\ThemeMain',
    'tools'                               => 'OxidEsales\\Eshop\\Application\\Controller\\Admin\\ToolsController',
    'tools_list'                          => 'OxidEsales\\Eshop\\Application\\Controller\\Admin\\ToolsList',
    'tools_main'                          => 'OxidEsales\\Eshop\\Application\\Controller\\Admin\\ToolsMain',
    'user_address'                        => 'OxidEsales\\Eshop\\Application\\Controller\\Admin\\UserAddress',
    'user_article'                        => 'OxidEsales\\Eshop\\Application\\Controller\\Admin\\UserArticle',
    'user_extend'                         => 'OxidEsales\\Eshop\\Application\\Controller\\Admin\\UserExtend',
    'usergroup'                           => 'OxidEsales\\Eshop\\Application\\Controller\\Admin\\UserGroupController',
    'usergroup_list'                      => 'OxidEsales\\Eshop\\Application\\Controller\\Admin\\UserGroupList',
    'usergroup_main'                      => 'OxidEsales\\Eshop\\Application\\Controller\\Admin\\UserGroupMain',
    'usergroup_main_ajax'                 => 'OxidEsales\\Eshop\\Application\\Controller\\Admin\\UserGroupMainAjax',
    'user_list'                           => 'OxidEsales\\Eshop\\Application\\Controller\\Admin\\UserList',
    'user_main'                           => 'OxidEsales\\Eshop\\Application\\Controller\\Admin\\UserMain',
    'user_main_ajax'                      => 'OxidEsales\\Eshop\\Application\\Controller\\Admin\\UserMainAjax',
    'user_overview'                       => 'OxidEsales\\Eshop\\Application\\Controller\\Admin\\UserOverview',
    'user_payment'                        => 'OxidEsales\\Eshop\\Application\\Controller\\Admin\\UserPayment',
    'user_remark'                         => 'OxidEsales\\Eshop\\Application\\Controller\\Admin\\UserRemark',
    'vendor'                              => 'OxidEsales\\Eshop\\Application\\Controller\\Admin\\VendorController',
    'vendor_list'                         => 'OxidEsales\\Eshop\\Application\\Controller\\Admin\\VendorList',
    'vendor_main'                         => 'OxidEsales\\Eshop\\Application\\Controller\\Admin\\VendorMain',
    'vendor_main_ajax'                    => 'OxidEsales\\Eshop\\Application\\Controller\\Admin\\VendorMainAjax',
    'vendor_mall'                         => 'OxidEsales\\Eshop\\Application\\Controller\\Admin\\VendorMall',
    'vendor_seo'                          => 'OxidEsales\\Eshop\\Application\\Controller\\Admin\\VendorSeo',
    'voucherserie'                        => 'OxidEsales\\Eshop\\Application\\Controller\\Admin\\VoucherSerieController',
    'voucherserie_export'                 => 'OxidEsales\\Eshop\\Application\\Controller\\Admin\\VoucherSerieExport',
    'voucherserie_generate'               => 'OxidEsales\\Eshop\\Application\\Controller\\Admin\\VoucherSerieGenerate',
    'voucherserie_groups'                 => 'OxidEsales\\Eshop\\Application\\Controller\\Admin\\VoucherSerieGroups',
    'voucherserie_groups_ajax'            => 'OxidEsales\\Eshop\\Application\\Controller\\Admin\\VoucherSerieGroupsAjax',
    'voucherserie_list'                   => 'OxidEsales\\Eshop\\Application\\Controller\\Admin\\VoucherSerieList',
    'voucherserie_main'                   => 'OxidEsales\\Eshop\\Application\\Controller\\Admin\\VoucherSerieMain',
    'voucherserie_mall'                   => 'OxidEsales\\Eshop\\Application\\Controller\\Admin\\VoucherSerieMall',
    'wrapping_list'                       => 'OxidEsales\\Eshop\\Application\\Controller\\Admin\\WrappingList',
    'wrapping_main'                       => 'OxidEsales\\Eshop\\Application\\Controller\\Admin\\WrappingMain',
    'wrapping_mall'                       => 'OxidEsales\\Eshop\\Application\\Controller\\Admin\\WrappingMall',
    'details'                             => 'OxidEsales\\Eshop\\Application\\Controller\\ArticleDetailsController',
    'alist'                               => 'OxidEsales\\Eshop\\Application\\Controller\\ArticleListController',
    'basket'                              => 'OxidEsales\\Eshop\\Application\\Controller\\BasketController',
    'clearcookies'                        => 'OxidEsales\\Eshop\\Application\\Controller\\ClearCookiesController',
    'compare'                             => 'OxidEsales\\Eshop\\Application\\Controller\\CompareController',
    'contact'                             => 'OxidEsales\\Eshop\\Application\\Controller\\ContactController',
    'content'                             => 'OxidEsales\\Eshop\\Application\\Controller\\ContentController',
    'credits'                             => 'OxidEsales\\Eshop\\Application\\Controller\\CreditsController',
    'download'                            => 'OxidEsales\\Eshop\\Application\\Controller\\DownloadController',
    'exceptionerror'                      => 'OxidEsales\\Eshop\\Application\\Controller\\ExceptionErrorController',
    'forgotpwd'                           => 'OxidEsales\\Eshop\\Application\\Controller\\ForgotPasswordController',
    'oxubase'                             => 'OxidEsales\\Eshop\\Application\\Controller\\FrontendController',
    'invite'                              => 'OxidEsales\\Eshop\\Application\\Controller\\InviteController',
    'links'                               => 'OxidEsales\\Eshop\\Application\\Controller\\LinksController',
    'mallstart'                           => 'OxidEsales\\Eshop\\Application\\Controller\\MallStartController',
    'manufacturerlist'                    => 'OxidEsales\\Eshop\\Application\\Controller\\ManufacturerListController',
    'moredetails'                         => 'OxidEsales\\Eshop\\Application\\Controller\\MoreDetailsController',
    'news'                                => 'OxidEsales\\Eshop\\Application\\Controller\\NewsController',
    'newsletter'                          => 'OxidEsales\\Eshop\\Application\\Controller\\NewsletterController',
    'order'                               => 'OxidEsales\\Eshop\\Application\\Controller\\OrderController',
    'oxstart'                             => 'OxidEsales\\Eshop\\Application\\Controller\\OxidStartController',
    'payment'                             => 'OxidEsales\\Eshop\\Application\\Controller\\PaymentController',
    'pricealarm'                          => 'OxidEsales\\Eshop\\Application\\Controller\\PriceAlarmController',
    'recommlist'                          => 'OxidEsales\\Eshop\\Application\\Controller\\RecommListController',
    'recommadd'                           => 'OxidEsales\\Eshop\\Application\\Controller\\RecommendationAddController',
    'register'                            => 'OxidEsales\\Eshop\\Application\\Controller\\RegisterController',
    'review'                              => 'OxidEsales\\Eshop\\Application\\Controller\\ReviewController',
    'rss'                                 => 'OxidEsales\\Eshop\\Application\\Controller\\RssController',
    'search'                              => 'OxidEsales\\Eshop\\Application\\Controller\\SearchController',
    'start'                               => 'OxidEsales\\Eshop\\Application\\Controller\\StartController',
    'suggest'                             => 'OxidEsales\\Eshop\\Application\\Controller\\SuggestController',
    'tpl'                                 => 'OxidEsales\\Eshop\\Application\\Controller\\TemplateController',
    'thankyou'                            => 'OxidEsales\\Eshop\\Application\\Controller\\ThankYouController',
    'user'                                => 'OxidEsales\\Eshop\\Application\\Controller\\UserController',
    'vendorlist'                          => 'OxidEsales\\Eshop\\Application\\Controller\\VendorListController',
    'wishlist'                            => 'OxidEsales\\Eshop\\Application\\Controller\\WishListController',
    'wrapping'                            => 'OxidEsales\\Eshop\\Application\\Controller\\WrappingController',
    'oxactionlist'                        => 'OxidEsales\\Eshop\\Application\\Model\\ActionList',
    'oxactions'                           => 'OxidEsales\\Eshop\\Application\\Model\\Actions',
    'oxaddress'                           => 'OxidEsales\\Eshop\\Application\\Model\\Address',
    'oxamountpricelist'                   => 'OxidEsales\\Eshop\\Application\\Model\\AmountPriceList',
    'oxarticle'                           => 'OxidEsales\\Eshop\\Application\\Model\\Article',
    'oxarticlelist'                       => 'OxidEsales\\Eshop\\Application\\Model\\ArticleList',
    'oxattribute'                         => 'OxidEsales\\Eshop\\Application\\Model\\Attribute',
    'oxattributelist'                     => 'OxidEsales\\Eshop\\Application\\Model\\AttributeList',
    'oxbasket'                            => 'OxidEsales\\Eshop\\Application\\Model\\Basket',
    'oxbasketcontentmarkgenerator'        => 'OxidEsales\\Eshop\\Application\\Model\\BasketContentMarkGenerator',
    'oxbasketitem'                        => 'OxidEsales\\Eshop\\Application\\Model\\BasketItem',
    'oxbasketreservation'                 => 'OxidEsales\\Eshop\\Application\\Model\\BasketReservation',
    'oxcategory'                          => 'OxidEsales\\Eshop\\Application\\Model\\Category',
    'oxcategorylist'                      => 'OxidEsales\\Eshop\\Application\\Model\\CategoryList',
    'oxcompanyvatin'                      => 'OxidEsales\\Eshop\\Application\\Model\\CompanyVatIn',
    'oxcontent'                           => 'OxidEsales\\Eshop\\Application\\Model\\Content',
    'oxcontentlist'                       => 'OxidEsales\\Eshop\\Application\\Model\\ContentList',
    'oxicachebackend'                     => 'OxidEsales\\Eshop\\Application\\Model\\Contract\\CacheBackendInterface',
    'oxicacheconnector'                   => 'OxidEsales\\Eshop\\Application\\Model\\Contract\\CacheConnectorInterface',
    'oxcountry'                           => 'OxidEsales\\Eshop\\Application\\Model\\Country',
    'oxcountrylist'                       => 'OxidEsales\\Eshop\\Application\\Model\\CountryList',
    'oxdelivery'                          => 'OxidEsales\\Eshop\\Application\\Model\\Delivery',
    'oxdeliverylist'                      => 'OxidEsales\\Eshop\\Application\\Model\\DeliveryList',
    'oxdeliveryset'                       => 'OxidEsales\\Eshop\\Application\\Model\\DeliverySet',
    'oxdeliverysetlist'                   => 'OxidEsales\\Eshop\\Application\\Model\\DeliverySetList',
    'oxdiagnostics'                       => 'OxidEsales\\Eshop\\Application\\Model\\Diagnostics',
    'oxdiagnosticsoutput'                 => 'OxidEsales\\Eshop\\Application\\Model\\DiagnosticsOutput',
    'oxdiscount'                          => 'OxidEsales\\Eshop\\Application\\Model\\Discount',
    'oxdiscountlist'                      => 'OxidEsales\\Eshop\\Application\\Model\\DiscountList',
    'oxfield2shop'                        => 'OxidEsales\\Eshop\\Application\\Model\\Field2Shop',
    'oxfile'                              => 'OxidEsales\\Eshop\\Application\\Model\\File',
    'oxfilechecker'                       => 'OxidEsales\\Eshop\\Application\\Model\\FileChecker',
    'oxfilecheckerresult'                 => 'OxidEsales\\Eshop\\Application\\Model\\FileCheckerResult',
    'oxfilecollector'                     => 'OxidEsales\\Eshop\\Application\\Model\\FileCollector',
    'oxgroups'                            => 'OxidEsales\\Eshop\\Application\\Model\\Groups',
    'oxlinks'                             => 'OxidEsales\\Eshop\\Application\\Model\\Links',
    'oxlistobject'                        => 'OxidEsales\\Eshop\\Application\\Model\\ListObject',
    'oxmaintenance'                       => 'OxidEsales\\Eshop\\Application\\Model\\Maintenance',
    'oxmanufacturer'                      => 'OxidEsales\\Eshop\\Application\\Model\\Manufacturer',
    'oxmanufacturerlist'                  => 'OxidEsales\\Eshop\\Application\\Model\\ManufacturerList',
    'oxmdvariant'                         => 'OxidEsales\\Eshop\\Application\\Model\\MdVariant',
    'oxmediaurl'                          => 'OxidEsales\\Eshop\\Application\\Model\\MediaUrl',
    'oxnews'                              => 'OxidEsales\\Eshop\\Application\\Model\\News',
    'oxnewslist'                          => 'OxidEsales\\Eshop\\Application\\Model\\NewsList',
    'oxnewssubscribed'                    => 'OxidEsales\\Eshop\\Application\\Model\\NewsSubscribed',
    'oxnewsletter'                        => 'OxidEsales\\Eshop\\Application\\Model\\Newsletter',
    'oxobject2category'                   => 'OxidEsales\\Eshop\\Application\\Model\\Object2Category',
    'oxobject2group'                      => 'OxidEsales\\Eshop\\Application\\Model\\Object2Group',
    'oxorder'                             => 'OxidEsales\\Eshop\\Application\\Model\\Order',
    'oxorderarticle'                      => 'OxidEsales\\Eshop\\Application\\Model\\OrderArticle',
    'oxorderarticlelist'                  => 'OxidEsales\\Eshop\\Application\\Model\\OrderArticleList',
    'oxorderfile'                         => 'OxidEsales\\Eshop\\Application\\Model\\OrderFile',
    'oxorderfilelist'                     => 'OxidEsales\\Eshop\\Application\\Model\\OrderFileList',
    'oxpayment'                           => 'OxidEsales\\Eshop\\Application\\Model\\Payment',
    'oxpaymentgateway'                    => 'OxidEsales\\Eshop\\Application\\Model\\PaymentGateway',
    'oxpaymentlist'                       => 'OxidEsales\\Eshop\\Application\\Model\\PaymentList',
    'oxpricealarm'                        => 'OxidEsales\\Eshop\\Application\\Model\\PriceAlarm',
    'oxrating'                            => 'OxidEsales\\Eshop\\Application\\Model\\Rating',
    'oxrecommlist'                        => 'OxidEsales\\Eshop\\Application\\Model\\RecommendationList',
    'oxremark'                            => 'OxidEsales\\Eshop\\Application\\Model\\Remark',
    'oxrequiredaddressfields'             => 'OxidEsales\\Eshop\\Application\\Model\\RequiredAddressFields',
    'oxrequiredfieldvalidator'            => 'OxidEsales\\Eshop\\Application\\Model\\RequiredFieldValidator',
    'oxrequiredfieldsvalidator'           => 'OxidEsales\\Eshop\\Application\\Model\\RequiredFieldsValidator',
    'oxreview'                            => 'OxidEsales\\Eshop\\Application\\Model\\Review',
    'oxrights'                            => 'OxidEsales\\Eshop\\Application\\Model\\Rights',
    'oxrole'                              => 'OxidEsales\\Eshop\\Application\\Model\\Role',
    'oxrssfeed'                           => 'OxidEsales\\Eshop\\Application\\Model\\RssFeed',
    'oxsearch'                            => 'OxidEsales\\Eshop\\Application\\Model\\Search',
    'oxselectlist'                        => 'OxidEsales\\Eshop\\Application\\Model\\SelectList',
    'oxselection'                         => 'OxidEsales\\Eshop\\Application\\Model\\Selection',
    'oxseoencoderarticle'                 => 'OxidEsales\\Eshop\\Application\\Model\\SeoEncoderArticle',
    'oxseoencodercategory'                => 'OxidEsales\\Eshop\\Application\\Model\\SeoEncoderCategory',
    'oxseoencodercontent'                 => 'OxidEsales\\Eshop\\Application\\Model\\SeoEncoderContent',
    'oxseoencodermanufacturer'            => 'OxidEsales\\Eshop\\Application\\Model\\SeoEncoderManufacturer',
    'oxseoencoderrecomm'                  => 'OxidEsales\\Eshop\\Application\\Model\\SeoEncoderRecomm',
    'oxseoencodervendor'                  => 'OxidEsales\\Eshop\\Application\\Model\\SeoEncoderVendor',
    'oxshop'                              => 'OxidEsales\\Eshop\\Application\\Model\\Shop',
    'oxshoplist'                          => 'OxidEsales\\Eshop\\Application\\Model\\ShopList',
    'oxshoprelations'                     => 'OxidEsales\\Eshop\\Application\\Model\\ShopRelations',
    'oxshopviewvalidator'                 => 'OxidEsales\\Eshop\\Application\\Model\\ShopViewValidator',
    'oxsimplevariant'                     => 'OxidEsales\\Eshop\\Application\\Model\\SimpleVariant',
    'oxsimplevariantlist'                 => 'OxidEsales\\Eshop\\Application\\Model\\SimpleVariantList',
    'oxsmartyrenderer'                    => 'OxidEsales\\Eshop\\Application\\Model\\SmartyRenderer',
    'oxstate'                             => 'OxidEsales\\Eshop\\Application\\Model\\State',
    'oxuser'                              => 'OxidEsales\\Eshop\\Application\\Model\\User',
    'oxuseraddresslist'                   => 'OxidEsales\\Eshop\\Application\\Model\\UserAddressList',
    'oxuserbasket'                        => 'OxidEsales\\Eshop\\Application\\Model\\UserBasket',
    'oxuserbasketitem'                    => 'OxidEsales\\Eshop\\Application\\Model\\UserBasketItem',
    'oxuserlist'                          => 'OxidEsales\\Eshop\\Application\\Model\\UserList',
    'oxuserpayment'                       => 'OxidEsales\\Eshop\\Application\\Model\\UserPayment',
    'oxvarianthandler'                    => 'OxidEsales\\Eshop\\Application\\Model\\VariantHandler',
    'oxvariantselectlist'                 => 'OxidEsales\\Eshop\\Application\\Model\\VariantSelectList',
    'oxvatselector'                       => 'OxidEsales\\Eshop\\Application\\Model\\VatSelector',
    'oxvendor'                            => 'OxidEsales\\Eshop\\Application\\Model\\Vendor',
    'oxvendorlist'                        => 'OxidEsales\\Eshop\\Application\\Model\\VendorList',
    'oxvoucher'                           => 'OxidEsales\\Eshop\\Application\\Model\\Voucher',
    'oxvoucherlist'                       => 'OxidEsales\\Eshop\\Application\\Model\\VoucherList',
    'oxvoucherserie'                      => 'OxidEsales\\Eshop\\Application\\Model\\VoucherSerie',
    'oxwrapping'                          => 'OxidEsales\\Eshop\\Application\\Model\\Wrapping',
    'oxadminrights'                       => 'OxidEsales\\Eshop\\Core\\AdminRights',
    'oxapplicationserver'                 => 'OxidEsales\\Eshop\\Core\\DataObject\\ApplicationServer',
    'oxarticle2shoprelations'             => 'OxidEsales\\Eshop\\Core\\Article2ShopRelations',
    'oxsupercfg'                          => 'OxidEsales\\Eshop\\Core\\Base',
    'oxcachebackenddefault'               => 'OxidEsales\\Eshop\\Core\\Cache\\DynamicContent\\Connector\\DefaultCacheConnector',
    'oxcachebackendzsdisk'                => 'OxidEsales\\Eshop\\Core\\Cache\\DynamicContent\\Connector\\ZendDiskCacheConnector',
    'oxcachebackendzsshm'                 => 'OxidEsales\\Eshop\\Core\\Cache\\DynamicContent\\Connector\\ZendShmCacheConnector',
    'oxcache'                             => 'OxidEsales\\Eshop\\Core\\Cache\\DynamicContent\\ContentCache',
    'oxcachebackend'                      => 'OxidEsales\\Eshop\\Core\\Cache\\Generic\\Cache',
    'oxcacheitem'                         => 'OxidEsales\\Eshop\\Core\\Cache\\Generic\\CacheItem',
    'oxfilecacheconnector'                => 'OxidEsales\\Eshop\\Core\\Cache\\Generic\\Connector\\FileCacheConnector',
    'oxmemcachedcacheconnector'           => 'OxidEsales\\Eshop\\Core\\Cache\\Generic\\Connector\\MemcachedCacheConnector',
    'oxreverseproxyconnector'             => 'OxidEsales\\Eshop\\Core\\Cache\\Generic\\Connector\\ReverseProxyCacheConnector',
    'oxzenddiskcacheconnector'            => 'OxidEsales\\Eshop\\Core\\Cache\\Generic\\Connector\\ZendDiskCacheConnector',
    'oxzendshmcacheconnector'             => 'OxidEsales\\Eshop\\Core\\Cache\\Generic\\Connector\\ZendShmCacheConnector',
    'oxreverseproxybackend'               => 'OxidEsales\\Eshop\\Core\\Cache\\ReverseProxy\\ReverseProxyBackend',
    'oxreverseproxyheader'                => 'OxidEsales\\Eshop\\Core\\Cache\\ReverseProxy\\ReverseProxyHeader',
    'oxreverseproxyurlgenerator'          => 'OxidEsales\\Eshop\\Core\\Cache\\ReverseProxy\\ReverseProxyUrlGenerator',
    'oxreverseproxyurlpartstoflush'       => 'OxidEsales\\Eshop\\Core\\Cache\\ReverseProxy\\ReverseProxyUrlPartsToFlush',
    'oxcategory2shoprelations'            => 'OxidEsales\\Eshop\\Core\\Category2ShopRelations',
    'oxcompanyvatinchecker'               => 'OxidEsales\\Eshop\\Core\\CompanyVatInChecker',
    'oxcompanyvatincountrychecker'        => 'OxidEsales\\Eshop\\Core\\CompanyVatInCountryChecker',
    'oxcompanyvatinvalidator'             => 'OxidEsales\\Eshop\\Core\\CompanyVatInValidator',
    'oxconfig'                            => 'OxidEsales\\Eshop\\Core\\Config',
    'oxconfigfile'                        => 'OxidEsales\\Eshop\\Core\\ConfigFile',
    'oxiconfigurable'                     => 'OxidEsales\\Eshop\\Core\\Contract\\IConfigurable',
    'oxicountryaware'                     => 'OxidEsales\\Eshop\\Core\\Contract\\ICountryAware',
    'oxidisplayerror'                     => 'OxidEsales\\Eshop\\Core\\Contract\\IDisplayError',
    'oximodulevalidator'                  => 'OxidEsales\\Eshop\\Core\\Contract\\IModuleValidator',
    'oxiselectlist'                       => 'OxidEsales\\Eshop\\Core\\Contract\\ISelectList',
    'oxiurl'                              => 'OxidEsales\\Eshop\\Core\\Contract\\IUrl',
    'oxview'                              => 'OxidEsales\\Eshop\\Core\\Controller\\BaseController',
    'oxcounter'                           => 'OxidEsales\\Eshop\\Core\\Counter',
    'oxccvalidator'                       => 'OxidEsales\\Eshop\\Core\\CreditCardValidator',
    'oxcurl'                              => 'OxidEsales\\Eshop\\Core\\Curl',
    'oxdb'                                => 'OxidEsales\\Eshop\\Core\\DatabaseProvider',
    'DatabaseInterface'                   => 'OxidEsales\\Eshop\\Core\\Database\\Adapter\\DatabaseInterface',
    'oxdbmetadatahandler'                 => 'OxidEsales\\Eshop\\Core\\DbMetaDataHandler',
    'oxdebuginfo'                         => 'OxidEsales\\Eshop\\Core\\DebugInfo',
    'oxdecryptor'                         => 'OxidEsales\\Eshop\\Core\\Decryptor',
    'oxdisplayerror'                      => 'OxidEsales\\Eshop\\Core\\DisplayError',
    'oxdynimggenerator'                   => 'OxidEsales\\Eshop\\Core\\DynamicImageGenerator',
    'oxelement2shoprelations'             => 'OxidEsales\\Eshop\\Core\\Element2ShopRelations',
    'oxelement2shoprelationsdbgateway'    => 'OxidEsales\\Eshop\\Core\\Element2ShopRelationsDbGateway',
    'oxelement2shoprelationssqlgenerator' => 'OxidEsales\\Eshop\\Core\\Element2ShopRelationsSqlGenerator',
    'oxemail'                             => 'OxidEsales\\Eshop\\Core\\Email',
    'oxencryptor'                         => 'OxidEsales\\Eshop\\Core\\Encryptor',
    'oxaccessrightexception'              => 'OxidEsales\\Eshop\\Core\\Exception\\AccessRightException',
    'oxarticleexception'                  => 'OxidEsales\\Eshop\\Core\\Exception\\ArticleException',
    'oxarticleinputexception'             => 'OxidEsales\\Eshop\\Core\\Exception\\ArticleInputException',
    'oxconnectionexception'               => 'OxidEsales\\Eshop\\Core\\Exception\\ConnectionException',
    'oxcookieexception'                   => 'OxidEsales\\Eshop\\Core\\Exception\\CookieException',
    'oxexceptionhandler'                  => 'OxidEsales\\Eshop\\Core\\Exception\\ExceptionHandler',
    'oxexceptiontodisplay'                => 'OxidEsales\\Eshop\\Core\\Exception\\ExceptionToDisplay',
    'oxfileexception'                     => 'OxidEsales\\Eshop\\Core\\Exception\\FileException',
    'oxinputexception'                    => 'OxidEsales\\Eshop\\Core\\Exception\\InputException',
    'oxlanguageexception'                 => 'OxidEsales\\Eshop\\Core\\Exception\\LanguageException',
    'oxnoarticleexception'                => 'OxidEsales\\Eshop\\Core\\Exception\\NoArticleException',
    'oxobjectexception'                   => 'OxidEsales\\Eshop\\Core\\Exception\\ObjectException',
    'oxoutofstockexception'               => 'OxidEsales\\Eshop\\Core\\Exception\\OutOfStockException',
    'oxshopexception'                     => 'OxidEsales\\Eshop\\Core\\Exception\\ShopException',
    'oxexception'                         => 'OxidEsales\\Eshop\\Core\\Exception\\StandardException',
    'oxsystemcomponentexception'          => 'OxidEsales\\Eshop\\Core\\Exception\\SystemComponentException',
    'oxuserexception'                     => 'OxidEsales\\Eshop\\Core\\Exception\\UserException',
    'oxvoucherexception'                  => 'OxidEsales\\Eshop\\Core\\Exception\\VoucherException',
    'oxexpirationemailbuilder'            => 'OxidEsales\\Eshop\\Core\\ExpirationEmailBuilder',
    'oxfield'                             => 'OxidEsales\\Eshop\\Core\\Field',
    'oxfilecache'                         => 'OxidEsales\\Eshop\\Core\\FileCache',
    'oxhasher'                            => 'OxidEsales\\Eshop\\Core\\Hasher',
    'oxheader'                            => 'OxidEsales\\Eshop\\Core\\Header',
    'oxinputvalidator'                    => 'OxidEsales\\Eshop\\Core\\InputValidator',
    'oxldap'                              => 'OxidEsales\\Eshop\\Core\\LDAP',
    'oxlang'                              => 'OxidEsales\\Eshop\\Core\\Language',
    'oxmailvalidator'                     => 'OxidEsales\\Eshop\\Core\\MailValidator',
    'oxbase'                              => 'OxidEsales\\Eshop\\Core\\Model\\BaseModel',
    'oxlist'                              => 'OxidEsales\\Eshop\\Core\\Model\\ListModel',
    'oxi18n'                              => 'OxidEsales\\Eshop\\Core\\Model\\MultiLanguageModel',
    'oxmodule'                            => 'OxidEsales\\Eshop\\Core\\Module\\Module',
    'oxmodulecache'                       => 'OxidEsales\\Eshop\\Core\\Module\\ModuleCache',
    'oxmodulechainsgenerator'             => 'OxidEsales\\Eshop\\Core\\Module\\ModuleChainsGenerator',
    'oxmoduleinstaller'                   => 'OxidEsales\\Eshop\\Core\\Module\\ModuleInstaller',
    'oxmodulelist'                        => 'OxidEsales\\Eshop\\Core\\Module\\ModuleList',
    'oxmodulemetadatavalidator'           => 'OxidEsales\\Eshop\\Core\\Module\\ModuleMetadataValidator',
    'oxmodulevalidatorfactory'            => 'OxidEsales\\Eshop\\Core\\Module\\ModuleValidatorFactory',
    'oxmodulevariableslocator'            => 'OxidEsales\\Eshop\\Core\\Module\\ModuleVariablesLocator',
    'oxnojsvalidator'                     => 'OxidEsales\\Eshop\\Core\\NoJsValidator',
    'oxonlinecaller'                      => 'OxidEsales\\Eshop\\Core\\OnlineCaller',
    'oxonlinelicensecheck'                => 'OxidEsales\\Eshop\\Core\\OnlineLicenseCheck',
    'oxonlinelicensecheckcaller'          => 'OxidEsales\\Eshop\\Core\\OnlineLicenseCheckCaller',
    'oxonlinelicensecheckrequest'         => 'OxidEsales\\Eshop\\Core\\OnlineLicenseCheckRequest',
    'oxonlinelicensecheckresponse'        => 'OxidEsales\\Eshop\\Core\\OnlineLicenseCheckResponse',
    'oxonlinemoduleversionnotifier'       => 'OxidEsales\\Eshop\\Core\\OnlineModuleVersionNotifier',
    'oxonlinemoduleversionnotifiercaller' => 'OxidEsales\\Eshop\\Core\\OnlineModuleVersionNotifierCaller',
    'oxonlinemodulesnotifierrequest'      => 'OxidEsales\\Eshop\\Core\\OnlineModulesNotifierRequest',
    'oxonlinerequest'                     => 'OxidEsales\\Eshop\\Core\\OnlineRequest',
    'oxonlineserveremailbuilder'          => 'OxidEsales\\Eshop\\Core\\OnlineServerEmailBuilder',
    'oxonlinevatidcheck'                  => 'OxidEsales\\Eshop\\Core\\OnlineVatIdCheck',
    'oxopensslfunctionalitychecker'       => 'OxidEsales\\Eshop\\Core\\OpenSSLFunctionalityChecker',
    'oxoutput'                            => 'OxidEsales\\Eshop\\Core\\Output',
    'oxpasswordhasher'                    => 'OxidEsales\\Eshop\\Core\\PasswordHasher',
    'oxpasswordsaltgenerator'             => 'OxidEsales\\Eshop\\Core\\PasswordSaltGenerator',
    'oxpicturehandler'                    => 'OxidEsales\\Eshop\\Core\\PictureHandler',
    'oxprice'                             => 'OxidEsales\\Eshop\\Core\\Price',
    'oxpricelist'                         => 'OxidEsales\\Eshop\\Core\\PriceList',
    'oxregistry'                          => 'OxidEsales\\Eshop\\Core\\Registry',
    'oxseodecoder'                        => 'OxidEsales\\Eshop\\Core\\SeoDecoder',
    'oxseoencoder'                        => 'OxidEsales\\Eshop\\Core\\SeoEncoder',
    'oxsepabicvalidator'                  => 'OxidEsales\\Eshop\\Core\\SepaBICValidator',
    'oxsepaibanvalidator'                 => 'OxidEsales\\Eshop\\Core\\SepaIBANValidator',
    'oxsepavalidator'                     => 'OxidEsales\\Eshop\\Core\\SepaValidator',
    'oxserial'                            => 'OxidEsales\\Eshop\\Core\\Serial',
    'oxsession'                           => 'OxidEsales\\Eshop\\Core\\Session',
    'oxsha512hasher'                      => 'OxidEsales\\Eshop\\Core\\Sha512Hasher',
    'oxshopcontrol'                       => 'OxidEsales\\Eshop\\Core\\ShopControl',
    'oxshopidcalculator'                  => 'OxidEsales\\Eshop\\Core\\ShopIdCalculator',
    'oxsimplexml'                         => 'OxidEsales\\Eshop\\Core\\SimpleXml',
    'emos'                                => 'OxidEsales\\Eshop\\Core\\Smarty\\Plugin\\Emos',
    'oxemosadapter'                       => 'OxidEsales\\Eshop\\Core\\Smarty\\Plugin\\EmosAdapter',
    'emos_item'                           => 'OxidEsales\\Eshop\\Core\\Smarty\\Plugin\\EmosItem',
    'oxstr'                               => 'OxidEsales\\Eshop\\Core\\Str',
    'oxstrmb'                             => 'OxidEsales\\Eshop\\Core\\StrMb',
    'oxstrregular'                        => 'OxidEsales\\Eshop\\Core\\StrRegular',
    'oxsubshopspecificfilecache'          => 'OxidEsales\\Eshop\\Core\\SubShopSpecificFileCache',
    'oxsystemeventhandler'                => 'OxidEsales\\Eshop\\Core\\SystemEventHandler',
    'oxsysrequirements'                   => 'OxidEsales\\Eshop\\Core\\SystemRequirements',
    'oxtableviewnamegenerator'            => 'OxidEsales\\Eshop\\Core\\TableViewNameGenerator',
    'oxtheme'                             => 'OxidEsales\\Eshop\\Core\\Theme',
    'oxuniversallyuniqueidgenerator'      => 'OxidEsales\\Eshop\\Core\\UniversallyUniqueIdGenerator',
    'oxusercounter'                       => 'OxidEsales\\Eshop\\Core\\UserCounter',
    'oxutils'                             => 'OxidEsales\\Eshop\\Core\\Utils',
    'oxutilscount'                        => 'OxidEsales\\Eshop\\Core\\UtilsCount',
    'oxutilsdate'                         => 'OxidEsales\\Eshop\\Core\\UtilsDate',
    'oxutilsfile'                         => 'OxidEsales\\Eshop\\Core\\UtilsFile',
    'oxutilsobject'                       => 'OxidEsales\\Eshop\\Core\\UtilsObject',
    'oxutilspic'                          => 'OxidEsales\\Eshop\\Core\\UtilsPic',
    'oxutilsserver'                       => 'OxidEsales\\Eshop\\Core\\UtilsServer',
    'oxutilsstring'                       => 'OxidEsales\\Eshop\\Core\\UtilsString',
    'oxutilsurl'                          => 'OxidEsales\\Eshop\\Core\\UtilsUrl',
    'oxutilsview'                         => 'OxidEsales\\Eshop\\Core\\UtilsView',
    'oxutilsxml'                          => 'OxidEsales\\Eshop\\Core\\UtilsXml',
    'oxviewconfig'                        => 'OxidEsales\\Eshop\\Core\\ViewConfig',
    'oxwidgetcontrol'                     => 'OxidEsales\\Eshop\\Core\\WidgetControl'
];
