<?php
/**
 * Copyright © OXID eSales AG. All rights reserved.
 * See LICENSE file for license details.
 */

/*
 * Capitalisation in this document:
 * First letter is always capitalized
 * All nouns are capitalized
 */
$sLangName = 'English';

// -------------------------------
// RESOURCE IDENTIFIER = STRING
// -------------------------------
$aLang = [

    'charset'          => 'UTF-8',
    'fullDateFormat'   => 'Y-m-d H:i:s',
    'simpleDateFormat' => 'Y-m-d',

    'COLON'                             => ':',
    'ELLIPSIS'                          => '...',
    'GENERAL_ACTIVE'                    => 'Active',
    'GENERAL_ALWAYS_ACTIVE'             => 'Always active',
    'GENERAL_ACTIVFROMTILL'             => 'Active for a period',
    'GENERAL_OR'                        => 'Or',
    'GENERAL_ACTIVTITLE'                => 'A',
    'GENERAL_ADMIN_TITLE'               => '[OXID eShop Administration]',
    'GENERAL_AJAX_ASSIGNALL'            => 'Assign all',
    'GENERAL_AJAX_DESCRIPTION'          => 'Drag items between the lists to assing/unassign',
    'GENERAL_AJAX_UNASSIGNALL'          => 'Unassign all',
    'GENERAL_AJAX_SORT_OXSORT'          => 'Position',
    'GENERAL_AJAX_SORT_OXPOS'           => 'Position',
    'GENERAL_AJAX_SORT_OXIDENT'         => 'Ident',
    'GENERAL_AJAX_SORT_OXVALDESC'       => 'Description',
    'GENERAL_AJAX_SORT_OXADDSUM'        => 'Cost',
    'GENERAL_AJAX_SORT_OXADDSUMTYPE'    => 'Type',
    'GENERAL_AJAX_SORT_OXUSERNAME'      => 'Login',
    'GENERAL_AJAX_SORT_OXLNAME'         => 'Last name',
    'GENERAL_AJAX_SORT_OXFNAME'         => 'First name',
    'GENERAL_AJAX_SORT_OXSTREET'        => 'Street',
    'GENERAL_AJAX_SORT_OXSTREETNR'      => 'Street Nr.',
    'GENERAL_AJAX_SORT_OXCITY'          => 'City',
    'GENERAL_AJAX_SORT_OXZIP'           => 'ZIP',
    'GENERAL_AJAX_SORT_OXFON'           => 'Phone',
    'GENERAL_AJAX_SORT_OXBIRTHDATE'     => 'Birth date',
    'GENERAL_AJAX_SORT_OXISOALPHA3'     => 'ISO Alpha 3',
    'GENERAL_AJAX_SORT_OXISOALPHA2'     => 'ISO Alpha 2',
    'GENERAL_AJAX_SORT_OXUNNUM3'        => 'Unique Nr',
    'GENERAL_AJAX_SORT_OXID'            => 'Id',
    'GENERAL_AJAX_SORT_OXDESC'          => 'Description',
    'GENERAL_AJAX_SORT_OXARTNUM'        => 'Art.Nr',
    'GENERAL_AJAX_SORT_OXTITLE'         => 'Title',
    'GENERAL_AJAX_SORT_OXEAN'           => 'EAN',
    'GENERAL_AJAX_SORT_OXMPN'           => 'MPN',
    'GENERAL_AJAX_SORT_OXPRICE'         => 'Price',
    'GENERAL_AJAX_SORT_OXSTOCK'         => 'Stock',
    'GENERAL_ALLGROUPS2'                => 'All User Groups',
    'GENERAL_ALLITEMS'                  => 'All available Products',
    'GENERAL_ARTNUM'                    => 'Prod.No.',
    'GENERAL_ARTICLE_OXACTIVEFROM'      => 'Active from',
    'GENERAL_ARTICLE_OXACTIVETO'        => 'Active until',
    'GENERAL_ARTICLE_OXARTNUM'          => 'Product Number',
    'GENERAL_ARTICLE_OXTITLE'           => 'Title',
    'GENERAL_ARTICLE_OXID'              => 'Internal Identno.',
    'GENERAL_ARTICLE_OXSHOPID'          => 'Shop Identno.',
    'GENERAL_ARTICLE_OXPARENTID'        => 'Identno. Main Product',
    'GENERAL_ARTICLE_OXACTIVE'          => 'Active',
    'GENERAL_ARTICLE_OXHIDDEN'          => 'Hidden',
    'GENERAL_ARTICLE_OXSHORTDESC'       => 'Short Description',
    'GENERAL_ARTICLE_OXLONGDESC'        => 'Detailed Description',
    'GENERAL_ARTICLE_OXPRICE'           => 'Price',
    'GENERAL_ARTICLE_OXBLFIXEDPRICE'    => 'oxblfixedprice',
    'GENERAL_ARTICLE_OXPRICEA'          => 'Price A',
    'GENERAL_ARTICLE_OXPRICEB'          => 'Price B',
    'GENERAL_ARTICLE_OXPRICEC'          => 'Price C',
    'GENERAL_ARTICLE_OXBPRICE'          => 'Gross Price',
    'GENERAL_ARTICLE_OXTPRICE'          => 'Old Price',
    'GENERAL_ARTICLE_OXEXTURL'          => 'External URL',
    'GENERAL_ARTICLE_OXUNITNAME'        => 'Unit',
    'GENERAL_ARTICLE_OXUNITQUANTITY'    => 'Quantity Unit',
    'GENERAL_ARTICLE_OXURLDESC'         => 'URL Description',
    'GENERAL_ARTICLE_OXURLIMG'          => 'External URL image',
    'GENERAL_ARTICLE_OXVAT'             => 'Product VAT',
    'GENERAL_ARTICLE_OXTHUMB'           => 'Preview Picture',
    'GENERAL_ARTICLE_OXICON'            => 'Icon',
    'GENERAL_ARTICLE_PICTURES'          => 'Product pictures',
    'GENERAL_ARTICLE_OXPIC1'            => 'Picture1',
    'GENERAL_ARTICLE_OXPIC2'            => 'Picture2',
    'GENERAL_ARTICLE_OXPIC3'            => 'Picture3',
    'GENERAL_ARTICLE_OXPIC4'            => 'Picture4',
    'GENERAL_ARTICLE_OXPIC5'            => 'Picture5',
    'GENERAL_ARTICLE_OXPIC6'            => 'Picture6',
    'GENERAL_ARTICLE_OXPIC7'            => 'Picture7',
    'GENERAL_ARTICLE_OXPIC8'            => 'Picture8',
    'GENERAL_ARTICLE_OXPIC9'            => 'Picture9',
    'GENERAL_ARTICLE_OXPIC10'           => 'Picture10',
    'GENERAL_ARTICLE_OXPIC11'           => 'Picture11',
    'GENERAL_ARTICLE_OXPIC12'           => 'Picture12',
    'GENERAL_ARTICLE_OXZOOM1'           => 'Zoom Picture 1',
    'GENERAL_ARTICLE_OXZOOM2'           => 'Zoom Picture 2',
    'GENERAL_ARTICLE_OXZOOM3'           => 'Zoom Picture 3',
    'GENERAL_ARTICLE_OXZOOM4'           => 'Zoom Picture 4',
    'GENERAL_ARTICLE_OXWEIGHT'          => 'Weight',
    'GENERAL_ARTICLE_OXSTOCK'           => 'Stock Quantity',
    'GENERAL_ARTICLE_OXSTOCKACTIVE'     => 'Stock Control Active',
    'GENERAL_ARTICLE_OXSTOCKFLAG'       => 'Stock Flag',
    'GENERAL_ARTICLE_OXDELIVERY'        => 'Shipped on',
    'GENERAL_ARTICLE_OXINSERT'          => 'Created on',
    'GENERAL_ARTICLE_OXTIMESTAMP'       => 'Last Modification',
    'GENERAL_ARTICLE_OXLENGTH'          => 'Length',
    'GENERAL_ARTICLE_OXWIDTH'           => 'Width',
    'GENERAL_ARTICLE_OXHEIGHT'          => 'Height',
    'GENERAL_ARTICLE_OXFILE'            => 'File',
    'GENERAL_ARTICLE_OXSEARCHKEYS'      => 'Search Keys',
    'GENERAL_ARTICLE_OXTEMPLATE'        => 'alt. Template',
    'GENERAL_ARTICLE_OXQUESTIONEMAIL'   => 'E-mail for question',
    'GENERAL_ARTICLE_OXISSEARCH'        => 'Is searchable',
    'GENERAL_ARTICLE_OXISCONFIGURABLE'  => 'Product is customizable',
    'GENERAL_ARTICLE_OXVARNAME'         => 'Variant Name',
    'GENERAL_ARTICLE_OXVARSELECT'       => 'oxvarselect',
    'GENERAL_ARTICLE_OXVARMINPRICE'     => 'Minimum price of all variants',
    'GENERAL_ARTICLE_OXFOLDER'          => 'Folder',
    'GENERAL_ARTICLE_OXSUBCLASS'        => 'oxsubclass',
    'GENERAL_ARTICLE_OXSORT'            => 'Sorting',
    'GENERAL_ARTICLE_OXSOLDAMOUNT'      => 'Quantity Sold',
    'GENERAL_ARTICLE_OXNONMATERIAL'     => 'Immaterial',
    'GENERAL_ARTICLE_OXFREESHIPPING'    => 'Free Shipping',
    'GENERAL_ARTICLE_OXREMINDACTIVE'    => 'Low stock e-mail active',
    'GENERAL_ARTICLE_OXREMINDAMOUNT'    => 'Low stock threshold',
    'GENERAL_ARTICLE_OXAMITEMID'        => 'oxamitemid',
    'GENERAL_ARTICLE_OXAMTASKID'        => 'oxamtaskid',
    'GENERAL_ARTICLE_OXVARMAXPRICE'     => 'Maximum price of all variants',
    'GENERAL_ARTICLE_OXVENDORID'        => 'Vendor ID',
    'GENERAL_ARTICLE_OXMANUFACTURERID'  => 'Manufacturer ID',
    'GENERAL_ARTICLE_OXVARCOUNT'        => 'Variant count',
    'GENERAL_ARTICLE_OXSHOPINCL'        => 'Shop include',
    'GENERAL_ARTICLE_OXSHOPEXCL'        => 'Shop exclude',
    'GENERAL_ARTICLE_OXSHOPINCL1'       => 'Shop include',
    'GENERAL_ARTICLE_OXSHOPEXCL1'       => 'Shop exclude',
    'GENERAL_ARTICLE_OXEAN'             => 'EAN',
    'GENERAL_ARTICLE_OXMPN'             => 'MPN',
    'GENERAL_ARTICLE_OXDISTEAN'         => 'Manufacturer EAN',
    'GENERAL_ARTICLE_OXSTOCKTEXT'       => 'In-Stock Message',
    'GENERAL_ARTICLE_OXNOSTOCKTEXT'     => 'Out-Of-Stock Mess.',
    'GENERAL_ARTICLE_OXSKIPDISCOUNTS'   => 'Skip discounts',
    'GENERAL_ARTICLE_OXRATINGCNT'       => 'Rating Count',
    'GENERAL_ARTICLE_OXRATING'          => 'Rating',
    'GENERAL_ARTICLE_OXRRVIEW'          => 'Exclusive viewable',
    'GENERAL_ARTICLE_OXRRBUY'           => 'Exclusive buyable',
    'GENERAL_ARTICLE_OXORDERINFO'       => 'Order Info',
    'GENERAL_ARTICLE_OXSEOID'           => 'SEOID',
    'GENERAL_ARTICLE_OXMINDELTIME'      => 'Min. delivery time',
    'GENERAL_ARTICLE_OXMAXDELTIME'      => 'Max. delivery time',
    'GENERAL_ARTICLE_OXDELTIMEUNIT'     => 'Delivery time unit',
    'GENERAL_ARTICLE_OXUPDATEPRICE'     => 'Update price',
    'GENERAL_ARTICLE_OXUPDATEPRICEA'    => 'Update price A',
    'GENERAL_ARTICLE_OXUPDATEPRICEB'    => 'Update price B',
    'GENERAL_ARTICLE_OXUPDATEPRICEC'    => 'Update price C',
    'GENERAL_ARTICLE_OXUPDATEPRICETIME' => 'Update price time',
    'GENERAL_ARTICLE_OXISDOWNLOADABLE'  => 'Is downloadable',

    'GENERAL_ARTICLE_OXVPE'          => 'Packingunit',
    'GENERAL_ARTICLE_OXBUNDLEID'     => 'Bundle Identno',
    'GENERAL_ARTICLE_OXVARSTOCK'     => 'Variant Stock',
    'GENERAL_ASSIGNEDTOSUBSHOPS'     => 'Assigned to subshops',
    'GENERAL_ASSIGNUSERS'            => 'Assign Users',
    'GENERAL_ASSIGNGROUPS'           => 'Assign User Groups',
    'GENERAL_ASSIGNARTICLE'          => 'Assign Product',
    'GENERAL_ASSIGNARTICLES'         => 'Assign Products',
    'GENERAL_ASSIGNCATEGORIES'       => 'Assign Categories',
    'GENERAL_ASSIGNCOUNTRIES'        => 'Assign Countries',
    'GENERAL_ATALL'                  => 'Total',
    'GENERAL_AUTO'                   => 'automatic',
    'GENERAL_BEGINDATE'              => 'Valid from',
    'GENERAL_BILLADDRESS'            => 'Billing Address: ',
    'GENERAL_BILLSAL'                => 'Title',
    'GENERAL_BIRTHDATE'              => 'Date of Birth',
    'GENERAL_CARD'                   => 'Greeting Card',
    'GENERAL_WRAPPING'               => 'Gift Wrapping',
    'GENERAL_CATEGORY'               => 'Category',
    'GENERAL_CATEGORYSELECT'         => 'Please select Category',
    'GENERAL_CLICKFORDETAILS'        => '(Click for Details)',
    'GENERAL_COMPANY'                => 'Company',
    'GENERAL_CHANGEPRODUCT'          => 'Choose product',
    'GENERAL_COPY'                   => 'Copy',
    'GENERAL_COPYTOSUBSHOPS'         => 'Copy to subshops',
    'GENERAL_COUNTRY'                => 'Country',
    'GENERAL_DATE'                   => 'Date',
    'GENERAL_DELETE'                 => 'Delete',
    'GENERAL_DELIVERYADDRESS'        => 'Shipping Address',
    'GENERAL_DELIVERYCOST'           => 'Shipping Costs',
    'GENERAL_DESCRIPTION'            => 'Description',
    'GENERAL_DISCOUNT'               => 'Discount',
    'GENERAL_EMAIL'                  => 'E-mail',
    'GENERAL_ENDDATE'                => 'Valid until',
    'GENERAL_ESTART'                 => 'Start Export',
    'GENERAL_EXPORTDELCOST'          => 'Please enter Shipping Costs:',
    'GENERAL_EXPORTMAINVARS'         => 'Export Variant of Base Product:',
    'GENERAL_EXPORTMINPRICE'         => 'Min. Gross Price:',
    'GENERAL_EXPORTCAMPAIGN'         => 'Promotion Parameter:',
    'GENERAL_EXPORTMINSTOCK'         => 'Min Stock Quantity:',
    'GENERAL_EXPOSTVARS'             => 'Export Variants:',
    'GENERAL_EXPORTLANGUAGE'         => 'Export for language',
    'GENERAL_EXPORTCUSTOMHEADER'     => 'User defined header',
    'GENERAL_EXTERNALSTOCK'          => 'External Storehouse',
    'GENERAL_EXTRAINFO'              => 'Additional Info',
    'GENERAL_FAX'                    => 'Fax',
    'GENERAL_FIELDS'                 => 'Fields',
    'GENERAL_FIELDS_ADD'             => 'Add Field',
    'GENERAL_FIELDS_DELETE'          => 'Delete Selected Fields',
    'GENERAL_FIELDS_MODIFY'          => 'Save Field',
    'GENERAL_FILE'                   => 'File',
    'GENERAL_FILTERING'              => 'Use * in beginning as wildcard sign',
    'GENERAL_FON'                    => 'Phone',
    'GENERAL_FROM'                   => 'From',
    'GENERAL_FROMCATEGORY'           => 'From Category: ',
    'GENERAL_IBRUTTO'                => 'Product Gross Price',
    'GENERAL_ICON'                   => 'Icon',
    'GENERAL_IDENT'                  => 'Ident',
    'GENERAL_INGROUP'                => 'In User Group',
    'GENERAL_INETTO'                 => 'Product Net Price',
    'GENERAL_IVAT'                   => 'VAT',
    'GENERAL_INFOLDER'               => 'In Folder',
    'GENERAL_LABEL'                  => 'Label',
    'GENERAL_LIST_FIRST'             => 'first',
    'GENERAL_LIST_PREV'              => 'previous',
    'GENERAL_LIST_NEXT'              => 'next',
    'GENERAL_LIST_LAST'              => 'last',
    'GENERAL_INSHOPPERMONTH'         => 'Shop per Month',
    'GENERAL_INSHOPPERWEEK'          => 'Shop per Week',
    'GENERAL_INTIME'                 => 'Time Frame',
    'GENERAL_MONTH'                  => 'Month',
    'GENERAL_MONTHS'                 => 'Months',
    'GENERAL_NODATA'                 => 'No Data available',
    'GENERAL_ITEM'                   => 'Product',
    'GENERAL_ITEMNR'                 => 'Prod.No.',
    'GENERAL_LANGUAGE'               => 'In Language: ',
    'GENERAL_LANGUAGE_NAME'          => 'Language',
    'GENERAL_LINK'                   => 'Link',
    'GENERAL_MANUEL'                 => 'Manual',
    'GENERAL_MANUELL'                => 'manual',
    'GENERAL_MENUITEM'               => 'Administer Products',
    'GENERAL_MANUFACTURER'           => 'Manufacturer',
    'GENERAL_MAX_FILE_UPLOAD'        => 'max.',
    'GENERAL_MAX_PICTURE_DIMENSIONS' => 'max. 1500*1500 px',
    'GENERAL_NAME'                   => 'Name',
    'GENERAL_NO'                     => 'No',
    'GENERAL_NOITEMSSEL'             => 'No Product selected',
    'GENERAL_NONAME'                 => 'no Name',
    'GENERAL_NONORDER'               => 'If out of Stock, not orderable',
    'GENERAL_NOWSEND'                => 'Ship Now',
    'GENERAL_OFF'                    => 'inactive',
    'GENERAL_OFFLINE'                => 'If out of Stock, offline',
    'GENERAL_ORDERNUM'               => 'Order No.',
    'GENERAL_OXIDESHOP'              => 'OXID eShop',
    'GENERAL_OUTOFBOUNDS'            => 'out of bounds',
    'GENERAL_PASSWORD'               => 'Password',
    'GENERAL_PAYCOST'                => 'Charge Payment Method',
    'GENERAL_PRICE'                  => 'Price',
    'GENERAL_RETURN'                 => 'Revenue last year, last month, last week',
    'GENERAL_REVIEW'                 => 'Overview',
    'GENERAL_REMARK'                 => 'Remark',
    'GENERAL_REQUIRED_MISS'          => 'Required field is missing',
    'GENERAL_SALUTATION_MR'          => 'Mr',
    'GENERAL_SALUTATION_MRS'         => 'Mrs',
    'GENERAL_SAVE'                   => 'Save',
    'GENERAL_SAVEIN'                 => 'Copy to',
    'GENERAL_SEARCH'                 => 'Search',
    'GENERAL_SEARCHKEY'              => 'Optional Search Keys',
    'GENERAL_SEARCHKEYS'             => 'Search Keys',
    'GENERAL_SENDEMAIL'              => 'Send e-mail?',
    'GENERAL_SENDON'                 => 'Shipped on ',
    'GENERAL_SEND'                   => 'Send',
    'GENERAL_NOSENT'                 => 'Order not shipped yet.',
    'GENERAL_SETBACKSENDTIME'        => 'Reset Shipping Date',
    'GENERAL_SEO_FIXED'              => 'Fixed URL',

    'GENERAL_SEO_ACTCAT'       => 'Active Category/Vendor',
    'GENERAL_SEO_CAT'          => '-- Category --',
    'GENERAL_SEO_VND'          => '-- Distributor --',
    'GENERAL_SEO_MANUFACTURER' => '-- Manufacturer --',
    'GENERAL_SEO_MAINCAT'      => '(main category)', // product seo tab near main category title
    'GENERAL_SEO_NOCAT'        => '(no category assigned)',   // product seo tab, article ha no category assigned

    'GENERAL_SEO_URL'                           => 'SEO URL',
    'GENERAL_SEO_OXKEYWORDS'                    => 'META Keywords',
    'GENERAL_SEO_OXDESCRIPTION'                 => 'META Description',
    'GENERAL_SEO_SHOWSUFFIX'                    => 'Show SEO Suffix in Category',
    'GENERAL_SHORTDESC'                         => 'Short Description',
    'GENERAL_SORT'                              => 'Sorting',
    'GENERAL_STANDARD'                          => 'Standard',
    'GENERAL_STARTLISTING'                      => 'Start Export List',
    'GENERAL_STATE'                             => 'State',
    'GENERAL_STREET'                            => 'Street',
    'GENERAL_STREETNUM'                         => 'Street, Street No.',
    'GENERAL_SUM'                               => 'Quantity',
    'GENERAL_SUMTOTAL'                          => 'Sum total',
    'GENERAL_SYSTEMERROR'                       => 'System error occured. Error message: <br> %s',
    'GENERAL_TELEPHONE'                         => 'Phone',
    'GENERAL_TILL'                              => 'To',
    'GENERAL_TITLE'                             => 'Title',
    'GENERAL_TITLEIDENT'                        => 'Working Title',
    'GENERAL_THUMB'                             => 'Thumbnail',
    'GENERAL_TYPE'                              => 'Type',
    'GENERAL_URL'                               => 'URL',
    'GENERAL_USER'                              => 'User',
    'GENERAL_USTID'                             => 'VAT ID No.',
    'GENERAL_VARIANTE'                          => 'Variant of ',
    'GENERAL_VENDOR'                            => 'Vendor',
    'GENERAL_VOUCHERS'                          => 'Coupon Discount',
    'GENERAL_YOUWANTTODELETE'                   => 'Do you really want to delete this entry?',
    'GENERAL_YOUWANTTOUNASSIGN'                 => 'Do you really want to unassign this entry from current shop?',
    'GENERAL_YES'                               => 'Yes',
    'GENERAL_ZIPCITY'                           => 'ZIP, City',
    'GENERAL_MAX_DOWNLOADS_COUNT'               => 'Maximum count of downloads',
    'GENERAL_LINK_EXPIRATION_TIME_UNREGISTERED' => 'Maximum count of downloads for not registered users',
    'GENERAL_LINK_EXPIRATION_TIME'              => 'Expiration time of download link',
    'GENERAL_DOWNLOAD_EXPIRATION_TIME'          => 'Expiration time of download link after the first download',
    'ACCESS_TO_EDIT_ACTION_FOR_MALL_ADMIN_ONLY' => 'Only Mall Admin is permitted to change promotions globally.',
    'ACTIONS_MAIN_NOTSELECTED'                  => 'Please select one from above list to make changes',
    'ACTIONS_MAIN_ALLARTICLES'                  => 'All available Products',
    'ACTIONS_MAIN_ALLARTICLESWITHATTR'          => 'Promoted Products',
    'ACTIONS_LIST_MENUITEM'                     => 'Customer Information',
    'ACTIONS_LIST_MENUSUBITEM'                  => 'Promotions',
    'ADMINLINKS_LIST_TITLE'                     => '[OXID Links Administration]',
    'ADMINLINKS_LIST_MENUITEM'                  => 'Customer Information',
    'ADMINLINKS_LIST_MENUSUBITEM'               => 'Links',
    'ADMIN_MALL_SELECT_ALL_SHOPS'               => 'Select All',
    'ADMIN_MALL_SELECT_NONE_SHOPS'              => 'Select None',
    'ARTICLE_ATTRIBUTE_TOOMANYATTRIBUTES'       => 'Please select only one Attribute!',
    'ARTICLE_ATTRIBUTE_NOATTRIBUTES'            => 'Please select one Attribute!',
    'ARTICLE_ATTRIBUTE_NOATTRIBUTE'             => 'Available Attributes',
    'ARTICLE_ATTRIBUTE_SELECTONEATTR'           => 'Please select an Attribute:',
    'ARTICLE_ATTRIBUTE_SAVE'                    => 'Save',
    'ARTICLE_ATTRIBUTE_OPENINNEWWINDOW'         => 'Create Attribute in new window',
    'ARTICLE_ATTRIBUTE_NOSELLIST'               => 'Available Selection Lists',
    'ARTICLE_ATTRIBUTE_ITEMSATTRIBUTE'          => "Product's Attributes",
    'ARTICLE_ATTRIBUTE_ITEMSSELLIST'            => "Product's Selection Lists",
    'ARTICLE_ATTRIBUTE_ASSIGNATTRIBUTE'         => 'Assign Attributes',
    'ARTICLE_ATTRIBUTE_ASSIGNSELECTLIST'        => 'Assign Selection Lists',
    'ARTICLE_BUNDLE_ASSIGNARTICLE'              => 'Assign Product',
    'ARTICLE_BUNDLE_UNASSIGNARTICLE'            => 'Unassign Product',
    'ARTICLE_BUNDLE_ASSIGNEDARTICLE'            => 'Bundled Product',
    'ARTICLE_BUNDLE_ALLITEMS'                   => 'All available Products',
    'ARTICLE_CROSSSELLING_CROSSSELLING'         => 'Crossselling Products',
    'ARTICLE_CROSSSELLING_EXTRAS'               => 'Accessories for Product',
    'ARTICLE_CROSSSELLING_ALLITEMS'             => 'All available Products',
    'ARTICLE_CROSSSELLING_ASSIGNCROSSSELLING'   => 'Assign Crosssellings',
    'ARTICLE_CROSSSELLING_ASSIGNACCESSORIES'    => 'Assign Accessories',
    'ARTICLE_EXTEND_MASS'                       => 'Dimensions',
    'ARTICLE_EXTEND_FILEUPLOAD'                 => 'File Upload: ',
    'ARTICLE_EXTEND_ALLCATS'                    => 'All available Categories',
    'ARTICLE_EXTEND_WEIGHT'                     => 'Weight',
    'ARTICLE_EXTEND_WEIGHT_UNIT'                => 'kg',
    'ARTICLE_EXTEND_DIMENSIONS_UNIT'            => 'm',
    'ARTICLE_EXTEND_LENGTH'                     => 'L',
    'ARTICLE_EXTEND_WIDTH'                      => 'W',
    'ARTICLE_EXTEND_HEIGHT'                     => 'H',
    'ARTICLE_EXTEND_UNITQUANTITY'               => 'Quantity',
    'ARTICLE_EXTEND_UNITNAME'                   => 'Unit',
    'ARTICLE_EXTEND_EXTURL'                     => 'External URL',
    'ARTICLE_EXTEND_URLDESC'                    => 'Text for external URL',
    'ARTICLE_EXTEND_BPRICE'                     => 'Purchase Price',
    'ARTICLE_EXTEND_TPRICE'                     => 'RRP',
    'ARTICLE_EXTEND_FILE'                       => 'File',
    'ARTICLE_EXTEND_TEMPLATE'                   => 'Alt. Template',
    'ARTICLE_EXTEND_QUESTIONEMAIL'              => 'Alt. Contact',
    'ARTICLE_EXTEND_ISSEARCH'                   => 'Searchable',
    'ARTICLE_EXTEND_ISCONFIGURABLE'             => 'Product can be customized',
    'ARTICLE_EXTEND_SHOWCUSTOMAGREEMENT'        => 'Confirm terms and conditions',
    'ARTICLE_EXTEND_NONMATERIAL'                => 'Intangible Product',
    'ARTICLE_EXTEND_FREESHIPPING'               => 'Free Shipping',
    'ARTICLE_EXTEND_BLFIXEDPRICE'               => 'Deactivate Price Alert',
    'ARTICLE_EXTEND_ARTINCATS'                  => 'Product is in these Categories',
    'ARTICLE_EXTEND_DEFAULT'                    => 'Set as Main Category',
    'ARTICLE_EXTEND_UPDATEMEDIA'                => 'Update media',
    'ARTICLE_EXTEND_ARTEXTRA'                   => 'Bundled Product',
    'ARTICLE_EXTEND_SKIPDISCOUNTS'              => 'Skip all negative Discounts<br>(Discounts, Vouchers, Delivery ...)',
    'ARTICLE_EXTEND_MEDIAURLS'                  => 'Media URLs',
    'ARTICLE_EXTEND_DESCRIPTION'                => 'Description',
    'ARTICLE_EXTEND_ENTERURL'                   => 'Enter existing media URL <br>(external PDF, movie, mp3 or YouTube!)',
    'ARTICLE_EXTEND_UPLOADFILE'                 => 'Or upload the file (large files should be uploaded via ftp)<br>(file name may only contain letters, numbers, underscore (_) and dot (.))',
    'ARTICLE_EXTEND_ERRORSAVINGTPRICE'          => 'Attention: RRP price must be bigger than normal price.',
    'ARTICLE_EXTEND_UPDATEPRICE'                => 'Base price',
    'ARTICLE_EXTEND_UPDATEPRICEA'               => 'A',
    'ARTICLE_EXTEND_UPDATEPRICEB'               => 'B',
    'ARTICLE_EXTEND_UPDATEPRICEC'               => 'C',
    'ARTICLE_EXTEND_UPDATEPRICETIME'            => 'Start time',
    'ARTICLE_EXTEND_UPDATEPRICES'               => 'Update price on defined time',
    'ARTICLE_EXTEND_UPLOADISDISABLED'           => 'This is a demoshop. Uploading files has been switched off due to security reasons.',
    'ARTICLE_LIST_ALLPRODUCTS'                  => 'all Products',
    'ARTICLE_LIST_MENUSUBITEM'                  => 'Product',
    'ARTICLE_MAIN_ERRORSAVINGARTICLE'           => 'Attention: Product already exists!',
    'ARTICLE_MAIN_PARENTNOTBUYABLE'             => 'Attention: Parent Product can not be purchased.',
    'ARTICLE_MAIN_ALDPRICE'                     => 'Alt. Prices',
    'ARTICLE_MAIN_NONE'                         => '-- none --',
    'ARTICLE_MAIN_GOTO'                         => 'Go to',
    'ARTICLE_MAIN_ACTIVETO'                     => 'To',
    'ARTICLE_MAIN_ACTIVEFROM'                   => 'From',
    'ARTICLE_MAIN_ACTIVE'                       => 'Active',
    'ARTICLE_MAIN_HIDDEN'                       => 'Hidden',
    'ARTICLE_MAIN_SHORTDESC'                    => 'Short Descr.',
    'ARTICLE_MAIN_PRICEA'                       => 'A',
    'ARTICLE_MAIN_PRICEB'                       => 'B',
    'ARTICLE_MAIN_PRICEC'                       => 'C',
    'ARTICLE_MAIN_VAT'                          => 'Spec. VAT',
    'ARTICLE_MAIN_ARTCOPY'                      => 'Copy Product',
    'ARTICLE_MAIN_VARIANTE'                     => 'Variant of ',
    'ARTICLE_MAIN_ACTIVFROMTILL'                => 'OR Active',
    'ARTICLE_MAIN_TITLE'                        => 'Title',
    'ARTICLE_MAIN_ARTNUM'                       => 'Prod.No.',
    'ARTICLE_MAIN_SEARCHKEYS'                   => 'Search Terms',
    'ARTICLE_MAIN_VENDORID'                     => 'Distributor',
    'ARTICLE_MAIN_PRICE'                        => 'Price',
    'ARTICLE_MAIN_SAVE'                         => 'Save',
    'ARTICLE_MAIN_INCATEGORY'                   => 'In Category',
    'ARTICLE_MAIN_ALLOWCUST'                    => 'Allow custom editing',
    'ARTICLE_MAIN_EAN'                          => 'EAN',
    'ARTICLE_MAIN_DISTEAN'                      => 'Man. EAN',
    'ARTICLE_MAIN_MPN'                          => 'MPN',
    'ARTICLE_MAIN_MANUFACTURERID'               => 'Manufacturer',
    'HELP_ARTICLE_MAIN_PRICE'                   => 'This price is inherited to product\'s variants.' .
                                                   '<ul><li>Depending on the shop settings net price or gross price is input/shown.</li>' .
                                                   '<li>Gross price is always shown in parentheses.</li></ul>',
    'ARTICLE_OVERVIEW_ARTMADEON'                => 'Product created on',
    'ARTICLE_OVERVIEW_LASTCHANGE'               => 'Last Modification on',
    'ARTICLE_OVERVIEW_SALEPOSITION'             => 'Position Sales Rating ',
    'ARTICLE_OVERVIEW_TOTALORDERCNT'            => 'Number of ordered Units',
    'ARTICLE_OVERVIEW_SOLDCNT'                  => 'Number of Units sold',
    'ARTICLE_OVERVIEW_CANCELEDCNT'              => 'Number of cancelled Units',
    'ARTICLE_OVERVIEW_LEFTORDERCNT'             => 'Number of pending Orders',
    'ARTICLE_PICTURES_PIC1UPLOAD'               => 'Picture 1 upload: ',
    'ARTICLE_PICTURES_PIC2UPLOAD'               => 'Picture 2 upload: ',
    'ARTICLE_PICTURES_PIC3UPLOAD'               => 'Picture 3 upload: ',
    'ARTICLE_PICTURES_PIC4UPLOAD'               => 'Picture 4 upload: ',
    'ARTICLE_PICTURES_PIC5UPLOAD'               => 'Picture 5 upload: ',
    'ARTICLE_PICTURES_PIC6UPLOAD'               => 'Picture 6 upload: ',
    'ARTICLE_PICTURES_PIC7UPLOAD'               => 'Picture 7 upload: ',
    'ARTICLE_PICTURES_ZOOM1UPLOAD'              => 'Zoom 1 upload: ',
    'ARTICLE_PICTURES_ZOOM2UPLOAD'              => 'Zoom 2 upload: ',
    'ARTICLE_PICTURES_ZOOM3UPLOAD'              => 'Zoom 3 upload: ',
    'ARTICLE_PICTURES_ZOOM4UPLOAD'              => 'Zoom 4 upload: ',
    'ARTICLE_PICTURES_SAVE'                     => 'Save',
    'ARTICLE_PICTURES_THUMBUPLOAD'              => 'Thumbn. upload: ',
    'ARTICLE_PICTURES_ICONUPLOAD'               => 'Icon upload: ',
    'ARTICLE_PICTURES_THUMB'                    => 'Thumbnail',
    'ARTICLE_PICTURES_ICON'                     => 'Icon',
    'ARTICLE_PICTURES_CUSTOM_PICTURES'          => 'Custom pictures',
    'ARTICLE_PICTURES_PIC1'                     => 'Picture 1',
    'ARTICLE_PICTURES_PIC2'                     => 'Picture 2',
    'ARTICLE_PICTURES_PIC3'                     => 'Picture 3',
    'ARTICLE_PICTURES_PIC4'                     => 'Picture 4',
    'ARTICLE_PICTURES_PIC5'                     => 'Picture 5',
    'ARTICLE_PICTURES_PIC6'                     => 'Picture 6',
    'ARTICLE_PICTURES_PIC7'                     => 'Picture 7',
    'ARTICLE_PICTURES_PREVIEW'                  => 'Preview',
    'ARTICLE_PICTURES_ZOOM1'                    => 'Zoom 1',
    'ARTICLE_PICTURES_ZOOM2'                    => 'Zoom 2',
    'ARTICLE_PICTURES_ZOOM3'                    => 'Zoom 3',
    'ARTICLE_PICTURES_ZOOM4'                    => 'Zoom 4',
    'ARTICLE_PICTURES_UPLOADISDISABLED'         => 'This is a demoshop. Uploading or deleting images has been switched off due to security reasons.',
    'ARTICLE_FILES_ISDOWNLOADABLE'              => 'Enable download of files for this product',
    'ARTICLE_FILES_TABLE_UPLOADEDFILES'         => 'Uploaded Files',
    'ARTICLE_FILES_TABLE_FILENAME'              => 'File name',
    'ARTICLE_FILES_NEW_PURCHASEDONLY'           => 'Download is available only after purchase',
    'ARTICLE_FILES_NEW_FILE'                    => 'Select a file for upload',
    'ARTICLE_FILES_NEW_UPLOAD'                  => 'Submit',
    'ARTICLE_FILES_ENTER_FILENAME'              => 'Enter name of uploaded file',
    'ARTICLE_FILES_OR'                          => 'or upload file',
    'ARTICLE_OTHER_OPTIONS'                     => 'Other options',
    'ARTICLE_REVIEW_DELETE'                     => 'Delete',
    'ARTICLE_REVIEW_SAVE'                       => 'Save',
    'ARTICLE_REVIEW_ACTIVE'                     => 'Active',
    'ARTICLE_REVIEW_POSTEDFROM'                 => 'Posted from: ',
    'ARTICLE_REVIEW_TEXT'                       => 'Text: ',
    'ARTICLE_RIGHTS_SETGROUPS_BUYABLE'          => 'Exclusively buyable by User Group',
    'ARTICLE_RIGHTS_SETGROUPS_VISIBLE'          => 'Exclusively visible to User Group',
    'ARTICLE_RIGHTS_ALLGROUPS'                  => 'All User Groups',
    'ARTICLE_RIGHTS_ASSIGNVISIBLE'              => 'Assign User Groups (Exclusively visible)',
    'ARTICLE_RIGHTS_ASSIGNBUYABLE'              => 'Assign User Groups (Exclusively buyable)',
    'ARTICLE_STOCK_AMOUNTPRICE_ABS'             => 'abs',
    'ARTICLE_STOCK_AMOUNTPRICE_DISCOUNT'        => '% Discount',
    'ARTICLE_STOCK_AMOUNTPRICE_PRICE'           => 'Price',
    'ARTICLE_STOCK_AMOUNTPRICE_AMOUNTFROM'      => 'Quantity From:',
    'ARTICLE_STOCK_AMOUNTPRICE_AMOUNTTO'        => 'To:',
    'ARTICLE_STOCK_PRICE'                       => 'Price',
    'ARTICLE_STOCK_AMOUNT'                      => 'Amount',
    'ARTICLE_STOCK_AMOUNTPRICE_TITLE'           => 'Scale Prices',
    'ARTICLE_STOCK_SAVE'                        => 'Save',
    'ARTICLE_STOCK_NOSTOCKTEXT'                 => 'Out Of Stock Message',
    'ARTICLE_STOCK_STOCKTEXT'                   => 'In Stock Message',
    'ARTICLE_STOCK_STOCK'                       => 'Stock',
    'ARTICLE_STOCK_STOCKFLAG'                   => 'Delivery Status',
    'ARTICLE_STOCK_DELIVERY'                    => 'Available on',
    'ARTICLE_STOCK_REMINDACTIV'                 => 'Send e-mail if stock falls below value',
    'ARTICLE_STOCK_DELTIME'                     => 'Delivery time',
    'ARTICLE_STOCK_MINDELTIME'                  => 'From',
    'ARTICLE_STOCK_MAXDELTIME'                  => 'to',
    'ARTICLE_STOCK_DAYS'                        => 'Days',
    'ARTICLE_STOCK_MONTHS'                      => 'Months',
    'ARTICLE_STOCK_WEEKS'                       => 'Weeks',
    'ARTICLE_STOCK_ORDERINFO'                   => 'Add. info in order confirmation mail.',
    'ARTICLE_STOCK_VPE'                         => 'Packingunit',
    'ARTICLE_STOCK_ERRORSCALEPRICE'             => 'Attention: Scale price must be lower than normal price.',
    'ARTICLE_USERDEF_USERDEFRANGE'              => 'User-defined Area - here you can add your own fields.',
    'ARTICLE_VARIANT_YOUWANTTODELETE'           => 'Do you really want to delete this Variant?',
    'ARTICLE_VARIANT_EDIT'                      => 'Edit',
    'ARTICLE_VARIANT_ARTSAVE'                   => 'Save Selection',
    'ARTICLE_VARIANT_NEWVAR'                    => 'New Variant',
    'ARTICLE_VARIANT_PRICE'                     => 'Price',
    'ARTICLE_VARIANT_ARTNUM'                    => 'Prod.No.',
    'ARTICLE_VARIANT_ACTIVE'                    => 'Active',
    'ARTICLE_VARIANT_SELECTLIST'                => 'Selection List',
    'ARTICLE_VARIANT_VARNAME'                   => 'Name of Selection',
    'ARTICLE_VARIANT_CHOICE'                    => 'Selection',
    'ARTICLE_VARIANT_SORT'                      => 'Sorting',
    'ARTICLE_VARIANT_STOCK'                     => 'Stock',
    'ARTICLE_VARIANT_VARSAVE'                   => 'Save Variants',
    'ATTRIBUTE_CATEGORY_ALLCATEGORY'            => 'All available Categories',
    'ATTRIBUTE_CATEGORY_ATRCATEGORY'            => 'Categories using this Attribute',
    'ATTRIBUTE_CATEGORY_ATRLIST'                => 'All Attributes of this Category',
    'ATTRIBUTE_LIST_MENUSUBITEM'                => 'Attributes',
    'ATTRIBUTE_MAIN_SORTING'                    => 'Sorting',
    'ATTRIBUTE_MAIN_ALLITEMS'                   => 'All available Products',
    'ATTRIBUTE_MAIN_ITEMSWITHATTR'              => 'Products with this Attribute',
    'ATTRIBUTE_MAIN_DISPLAYINBASKET'            => 'Display attribute\'s value for products in checkout',
    'AUCTMASTER_DO_TITLE'                       => 'Import/Export',
    'AUCTMASTER_DO_UNKNOWNERROR'                => 'Unknown Error!',
    'AUCTMASTER_DO_EXPORTNOTSTARTED'            => 'Export not yet started.',
    'AUCTMASTER_DO_EXPORTEND'                   => 'Export completed.',
    'AUCTMASTER_DO_EXPORTFILE'                  => 'Not able to write to export file %s',
    'GENEXPORT_EXPRUNNING'                      => 'Export running.',
    'GENEXPORT_EXPORTEDITEMS'                   => 'Products exported',
    'BOTTOMNAVIITEM_ATTENTION'                  => 'ATTENTION: This function can delete categories - backup before execution!',
    'CATEGORY_LIST_MENUSUBITEM'                 => 'Categories',
    'CATEGORY_MAIN_ACTIVE'                      => 'Active',
    'CATEGORY_MAIN_ASC'                         => 'asc',
    'CATEGORY_MAIN_DEFSORT'                     => 'Fast Sorting',
    'CATEGORY_MAIN_DESC'                        => 'desc',
    'CATEGORY_MAIN_EXTLINK'                     => 'External Link (e.g.<br>http://www.example.com)',
    'CATEGORY_MAIN_HIDDEN'                      => 'Hidden',
    'CATEGORY_MAIN_ICONUPLOAD'                  => 'Upload Icon',
    'CATEGORY_MAIN_ITEMSINCATEGORY'             => 'Products in this Category',
    'CATEGORY_MAIN_NONE'                        => '-- none --',
    'CATEGORY_MAIN_PRICEFROMTILL'               => 'Price from/to',
    'CATEGORY_MAIN_TEMPLATE'                    => 'Alt Template',
    'CATEGORY_MAIN_THUMBUPLOAD'                 => 'Upload Picture',
    'CATEGORY_MAIN_VAT'                         => 'Spec. VAT',
    'CATEGORY_MAIN_DESCRIPTION'                 => 'Short Description',
    'CATEGORY_MAIN_SAVE'                        => 'Save',
    'CATEGORY_MAIN_ALLITEMS'                    => 'All available Products',
    'CATEGORY_MAIN_ICON'                        => 'Icon',
    'CATEGORY_MAIN_PROMOTION_ICON'              => 'Icon for promotions',
    'CATEGORY_MAIN_SORT'                        => 'Sorting',
    'CATEGORY_MAIN_TITLE'                       => 'Title',
    'CATEGORY_MAIN_PARENTID'                    => 'Subcategory of',
    'CATEGORY_MAIN_THUMB'                       => 'Picture Name',
    'CATEGORY_MAIN_SKIPDISCOUNTS'               => 'Skip all negative Discounts<br> (Discounts, Vouchers, Delivery ...)',
    'CATEGORY_MALL_ASSIGNONLYPARENTWARNING'     => 'You can only assign full category tree to other subshops.',
    'CATEGORY_MALL_CLICKHEREFORPARENT'          => 'Click here to edit parent assignment.',
    'CATEGORY_PICTURES_UPLOADISDISABLED'        => 'This is a demoshop. Uploading or deleting images has been switched off due to security reasons.',
    'CATEGORY_ORDER_ACTSORT'                    => 'Current Sorting',
    'CATEGORY_ORDER_NEWSORT'                    => 'New Sorting',
    'CATEGORY_ORDER_NEWSORTSAVE'                => 'Save new sorting',
    'CATEGORY_ORDER_DELETESORT'                 => 'Delete Sorting',
    'CATEGORY_ORDER_SORTCATEGORIES'             => 'Sort Categories',
    'CATEGORY_RIGHTS_SETGROUPS_BUYABLE'         => 'Exclusively buyable by User Group',
    'CATEGORY_RIGHTS_ALLGROUPS'                 => 'All User Groups',
    'CATEGORY_RIGHTS_APPLYLEVEL'                => 'Apply changes to category and its products only',
    'CATEGORY_RIGHTS_APPLYLEVEL2'               => 'Apply changes to category, subcategories and its products',
    'CATEGORY_RIGHTS_SETGROUPS_VISIBLE'         => 'Exclusively visible by User Group',
    'CATEGORY_RIGHTS_ALLGROUPS2'                => 'All User Groups',
    'CATEGORY_RIGHTS_APPLYLEVEL3'               => 'Apply changes to category and its products only',
    'CATEGORY_RIGHTS_APPLYLEVEL4'               => 'Apply changes to category, subcategories and its products',
    'CATEGORY_RIGHTS_ASSIGNVISIBLE'             => 'Assign User Groups (Exclusively visible)',
    'CATEGORY_RIGHTS_ASSIGNBUYABLE'             => 'Assign User Groups (Exclusively buyable)',
    'CATEGORY_TEXT_SAVE'                        => 'Save',
    'CATEGORY_UPDATE_TITLE'                     => '[OXID Category Indexing]',
    'CATEGORY_UPDATE_CLOSE'                     => 'Close',
    'CMSFOLDER_NONE'                            => 'None',
    'CMSFOLDER_EMAILS'                          => 'E-mails',
    'CMSFOLDER_USERINFO'                        => 'Customer information',
    'CMSFOLDER_PRODUCTINFO'                     => 'Product information',
    'CONTENT_LIST_ALL'                          => 'All',
    'CONTENT_LIST_MENUITEM'                     => 'Customer Information',
    'CONTENT_LIST_MENUSUBITEM'                  => 'CMS Pages',
    'CONTENT_MAIN_MAINMENU'                     => 'Upper Menu',
    'CONTENT_MAIN_INSERTBEFORE'                 => 'Inserted before',
    'CONTENT_MAIN_SNIPPET'                      => 'Snippet',
    'CONTENT_MAIN_TITLE'                        => '[OXID Content Administration]',
    'CONTENT_MAIN_TERMVER'                      => 'Version',
    'CONTENT_MAIN_ERROR'                        => 'ERROR!',
    'CONTENT_MAIN_USEDIDENTCODE'                => 'Identcode already in use!',
    'CONTENT_MAIN_CATEGORY'                     => 'Category',
    'CONTENT_MAIN_MANUAL'                       => 'Manually',
    'COUNTRY_LIST_ISO'                          => 'ISO 3',
    'COUNTRY_LIST_MENUITEM'                     => 'Master Settings',
    'COUNTRY_LIST_MENUSUBITEM'                  => 'Countries',
    'COUNTRY_MAIN_ISO2'                         => 'ISO 2',
    'COUNTRY_MAIN_ISO3'                         => 'ISO 3',
    'COUNTRY_MAIN_ISOUNNUM'                     => 'ISO UN Number',
    'COUNTRY_MAIN_OPDESCRIPTION'                => 'Optional Description',
    'COUNTRY_MAIN_OXVATSTATUS'                  => 'VAT handling',
    'COUNTRY_MAIN_OXVATSTATUS_0'                => 'Do not bill VAT',
    'COUNTRY_MAIN_OXVATSTATUS_1'                => 'Do not bill VAT only if provided valid VAT ID',
    'DELIVERY_ARTICLES_ALLCATEGORIES'           => 'All Categories',
    'DELIVERY_ARTICLES_SETCATEGORIES'           => 'Assigned Categories',
    'DELIVERY_ARTICLES_ALLATRICLES'             => 'All Products',
    'DELIVERY_ARTICLES_SETARTICLES'             => 'Assigned Products',
    'DELIVERY_COUNTRIES_ALLCOUNTRIES'           => 'All Countries',
    'DELIVERY_COUNTRIES_SETCOUNTRIES'           => 'Assigned Countries',
    'DELIVERY_LIST_MENUITEM'                    => 'Shop Settings',
    'DELIVERY_LIST_MENUSUBITEM'                 => 'Shipping Cost Rules',
    'DELIVERY_MAIN_CONDITION'                   => 'Condition',
    'DELIVERY_MAIN_ORDER'                       => 'Order of Rule Processing',
    'DELIVERY_MAIN_FINALIZE'                    => 'Don\'t calculate further Rules if this Rule matches',
    'DELIVERY_MAIN_PARAM'                       => 'Payment Method',
    'DELIVERY_MAIN_PRICE'                       => 'Price Surcharge/Discount',
    'DELIVERY_MAIN_AND'                         => 'and',
    'DELIVERY_MAIN_COUNTRULES'                  => 'Calculation Rules: ',
    'DELIVERY_MAIN_ONETIMEPERITEMINWK'          => ' For each product',
    'DELIVERY_MAIN_ONETIMEPERITEM'              => ' Once for each different product',
    'DELIVERY_MAIN_ONETIMEPERWK'                => ' Once per Cart',
    'DELIVERY_USERS_SETGROUPS'                  => 'Assigned User Groups',
    'DELIVERY_USERS_ALLUSERSINGROUP'            => 'All Users',
    'DELIVERY_USERS_SETUSER'                    => 'Assigned Users',
    'DELIVERYSET_LIST_MENUITEM'                 => 'Shop Settings',
    'DELIVERYSET_LIST_MENUSUBITEM'              => 'Shipping Methods',
    'DELIVERYSET_MAIN_ALLDELIVERYCOST'          => 'All Shipping Cost Rules',
    'DELIVERYSET_MAIN_SELDELIVERYCOST'          => 'Assigned Shipping Cost Rules',
    'DELIVERYSET_MAIN_ASSIGNDELIVERY'           => 'Assign Shipping Cost Rules',
    'DELIVERYSET_PAYMENT_ALLPAYMENTS'           => 'All Payment Methods',
    'DELIVERYSET_PAYMENT_SELPAYMENTS'           => 'Assigned Payment Methods',
    'DELIVERYSET_PAYMENT_ASSIGNPAYMENT'         => 'Assign Payment Methods',
    'DISCOUNT_ARTICLES_ALLATRICLES'             => 'All Products',
    'DISCOUNT_ARTICLES_ALLCATEGORIES'           => 'All Categories',
    'DISCOUNT_ARTICLES_SETARTICLES'             => 'Assigned Products',
    'DISCOUNT_ARTICLES_SETCATEGORIES'           => 'Assigned Categories',
    'DISCOUNT_COUNTRIES_ALLCOUNTRIES'           => 'All Countries',
    'DISCOUNT_COUNTRIES_SETCOUNTRIES'           => 'Assigned Countries',
    'DISCOUNT_LIST_MENUITEM'                    => 'Shop Settings',
    'DISCOUNT_ERROR_OXSORT_NOT_A_NUMBER'        => 'Error: The value of the field "%s" must be a number.',
    'DISCOUNT_ERROR_OXSORT_NOT_UNIQUE'          => 'Error: The value of the field "%s" must be unique.',
    'DISCOUNT_LIST_MENUSUBITEM'                 => 'Discounts',
    'DISCOUNT_MAIN_AFROM'                       => '(From)',
    'DISCOUNT_MAIN_ATILL'                       => '(To)',
    'DISCOUNT_MAIN_AMOUNT'                      => 'Quantity',
    'DISCOUNT_MAIN_PRICE'                       => 'Purchase Price',
    'DISCOUNT_MAIN_REBATE'                      => 'Discount',
    'DISCOUNT_MAIN_EXTRA'                       => 'Free Product',
    'DISCOUNT_MAIN_SORT'                        => 'Sorting',
    'DISCOUNT_MAIN_MULTIPLY_DISCOUNT_ARTICLES'  => 'Multiply',
    'DISCOUNT_MAIN_MULTIPLY_DISCOUNT_AMOUNT'    => 'Amount',
    'DISCOUNT_USERS_ALLUSERSINGROUP'            => 'All Users',
    'DISCOUNT_USERS_SETGROUPS'                  => 'Assigned User Groups',
    'DISCOUNT_USERS_SETUSER'                    => 'Assigned Users',
    'DYN_ECONDA_ACTIVE'                         => 'Activate Econda Webcontrolling?',
    'DYN_ECONDA_ATTENTION'                      => 'Please note: ',
    'DYN_ECONDA_COPY_FILE'                      => 'You have to copy the file "emos2.js" which you receive from Econda into the directory %s',

    'DYNBASE_ADDCATTOCAMPAIGN'                       => 'Add category to campaign parameter',
    'DYNBASE_DO_SUCCESS'                             => 'Success! Your export file can be downloaded <a href="%s" target="_blank">here</a>',
    'DYNBASE_DO_LINK'                                => 'The Partner can also pick-up this file himself - please note following Link: ',
    'DYNSCREEN_TITLE'                                => 'marketing',
    'DYNSCREEN_LIST_SERVICE'                         => 'Service Area',
    'EDITOR_PLAINTEXT_HINT'                          => '<b>Note:</b> If you need to preserve text line breaks (e.g. plaintext e-mails), please use tab "html CODE" instead of "Design".',
    'ALTERNATIVE_IMAGE_SERVER_NOTE'                  => '<b>Note:</b> Alternative image server configuration detected, files will not be uploaded to remote location. Please take care about synchronization manually.',
    'EXCEPTION_USER_USEREXISTS'                      => 'This user allready exists!',
    'EXCEPTION_CONNECTION_NODB'                      => 'No connection to database!',
    'EXCEPTION_ACCESSRIGHT_ACCESSDENIED'             => 'Access denied, no sufficient rights!',
    'EXCEPTION_CURL_ERROR'                           => 'cURL error: %s',
    'EXCEPTION_DELETING_VALID_FILE'                  => 'You cannot delete this file, as long as it has valid downloads',
    'EXCEPTION_NOFILE'                               => 'No uploaded file',
    'EXCEPTION_FILENAMEINVALIDCHARS'                 => 'Invalid chars in file name',
    'EXCEPTION_FILEUPLOADERROR_1'                    => 'The uploaded file exceeds maximum allowed size', // message is taken from php docu
    'EXCEPTION_FILEUPLOADERROR_2'                    => 'The uploaded file exceeds maximum allowed size', // message is taken from php docu
    'EXCEPTION_FILEUPLOADERROR_3'                    => 'The uploaded file was only partially uploaded', // message is taken from php docu
    'EXCEPTION_FILEUPLOADERROR_4'                    => 'No file was uploaded', // message is taken from php docu
    'EXCEPTION_FILEUPLOADERROR_6'                    => 'Missing a temporary folder', // message is taken from php docu
    'EXCEPTION_FILEUPLOADERROR_7'                    => 'Failed to write file to disk', // message is taken from php docu
    'EXCEPTION_FILEUPLOADERROR_8'                    => 'File upload stopped by extension', // message is taken from php docu
    'EXCEPTION_NOTALLOWEDTYPE'                       => 'Not allowed file type (please, edit config.inc.php to allow this type of file)',
    'EXCEPTION_NODESCRIPTIONADDED'                   => 'Please enter description',
    'EXCEPTION_NOMEDIAADDED'                         => 'Please enter existing media URL or upload the file',
    'EXCEPTION_COULDNOTWRITETOFILE'                  => 'Could not write to file',
    'EXCEPTION_FILENOTFOUND'                         => 'File not found (see EXCEPTION_LOG.txt for details)',
    'EXCEPTION_THEME_NOT_LOADED'                     => 'Theme could not be loaded',
    'EXCEPTION_MODULE_NOT_LOADED'                    => 'Module could not be loaded',
    'EXCEPTION_PARENT_VERSION_UNSPECIFIED'           => 'Parent theme did not specify version',
    'EXCEPTION_UNSPECIFIED_PARENT_VERSIONS'          => 'Compatible parent theme version not specified',
    'EXCEPTION_PARENT_VERSION_MISMATCH'              => 'Parent theme version is not compatible',
    'EXCEPTION_PARENT_THEME_NOT_FOUND'               => 'Cannot find parent theme',
    'NO_PICTURES_CHANGES'                            => 'No pictures changes',
    'EXCEPTION_SYSTEMCOMPONENT_TEMPLATENOTFOUND'     => 'Template "%s" not found',
    'EXCEPTION_DISABLED_DOWNLOADABLE_PRODUCTS'       => 'To use this feature in frontend, you have to enable config option \'Enable downloadable products\' in Master Settings -> Core Settings -> Settings -> Downloadable products.',
    'ERROR_MESSAGE_SYSTEMCOMPONENT_CLASSNOTFOUND'    => 'Class "%s" not found',
    'EXCEPTION_SYSTEMCOMPONENT_CLASSNOTFOUND'        => 'Class "%s" not found!',
    'ERROR_MESSAGE_SYSTEMCOMPONENT_FUNCTIONNOTFOUND' => 'Function "%s" not found',
    'THEME_AUTHOR'                                   => 'Author',
    'THEME_VERSION'                                  => 'Version',
    'THEME_ACTIVATE'                                 => 'Activate',
    'THEME_PARENT_THEME_TITLE'                       => 'Parent theme',
    'THEME_PARENT_VERSIONS'                          => 'Compatible parent theme versions',
    'MODULE_ID'                                      => 'Module ID',
    'MODULE_PROBLEMATIC_FILES'                       => 'Problematic files',
    'MODULE_AUTHOR'                                  => 'Author',
    'MODULE_VERSION'                                 => 'Version',
    'MODULE_ACTIVATION_NOT_POSSIBLE_IN_DEMOMODE'     => "Please note: modules can't be activated or deactivated in demo shop mode.",
    'MODULE_ACTIVATE'                                => 'Activate',
    'MODULE_DEACTIVATE'                              => 'Deactivate',
    'MODULE_DRAGANDDROP'                             => 'Drag items to change modules order. After changing order press Save button to save current modules order.',
    'MODULE_EDITEXTENSION'                           => 'Edit module information',
    'MODULE_ENABLEACTIVATIONTEXT'                    => 'Module has no metadata file, so for registering module you must manually enter which classes module extends (e.g. oxorder => myModule/myModuleOxorder). This must be done only once.',
    'MODULE_ENTERMODULENAME'                         => 'Module name',
    'MODULE_ENTERMODULEID'                           => 'Module ID',
    'MODULE_ENTERMODULEEXTENDSCLASSES'               => 'Extended classes',
    'MODULE_EXTENSIONISDELETED'                      => 'Invalid modules were detected.',
    'MODULE_DELETEEXTENSION'                         => 'Do you want to delete all registered module information and saved configurations?',
    'MODULE_PASSWORDS_DO_NOT_MATCH'                  => 'Passwords do not match!',
    'MODULE_REPEAT_PASSWORD'                         => 'Confirm password',
    //@TODO: integrate links to documentation when it is officially available
    // In MODULE_METADATA_PROBLEMATIC_DATA_IN_EXTEND ad links to offical equivalents of
    // http://oxid-eshop-developer-documentation.readthedocs.io/en/latest/modules/metadata/version20.html
    // and http://oxid-eshop-developer-documentation.readthedocs.io/en/latest/modules/using_namespaces_in_modules.html
    'MODULE_METADATA_PROBLEMATIC_DATA_IN_EXTEND'     => 'Invalid metadata in extend section. The following extended shop classes are either mistyped or don\'t belong to the Unified Namespace: <br> %s',
    'LANGUAGE_ERRORGENERATEVIEWS'                    => "Please don't forget to update the database views under Service->Tools",
    'LANGUAGE_ACTIVE'                                => 'Active in frontend',
    'LANGUAGE_LIST_MENUITEM'                         => 'Master Settings',
    'LANGUAGE_LIST_MENUSUBITEM'                      => 'Languages',
    'LANGUAGE_ABBERVATION'                           => 'Abbreviation',
    'LANGUAGE_DESCRIPTION'                           => 'Name',
    'LANGUAGE_DEFAULT'                               => 'Is default',
    'LANGUAGE_LANGUAGEID'                            => 'Language ID',
    'LANGUAGE_BASEURL'                               => 'Base URL',
    'LANGUAGE_BASESSLURL'                            => 'Base SSL URL',
    'LANGUAGE_FRONTEND_NOTRANSLATIONS_WARNING'       => 'Attention: No language files were found in theme or /out dir for selected language!',
    'LANGUAGE_BACKEND_NOTRANSLATIONS_WARNING'        => 'Attention: No language files were found in /admin dir for selected language!',
    'LANGUAGE_NOTRANSLATIONS_WARNING'                => 'Attention: No language files were found in templates dir for selected language!',
    'LANGUAGE_ERROR_ADDING_MULTILANG_FIELDS'         => 'Attention: Error occured while adding new multilanguage fields to tables!',
    'LANGUAGE_ERROR_RESETING_MULTILANG_FIELDS'       => 'Attention: Error occured while reseting multilanguage fields after language delete!',
    'LANGUAGE_DELETINGMAINLANG_WARNING'              => 'Attention: you can\'t delete main language (with ID = 0)!',
    'LANGUAGE_ABBRCHANGEMAINLANG_WARNING'            => 'Attention: you can\'t change abbreviation of main language (with ID = 0)!',
    'LANGUAGE_ALREADYEXISTS_ERROR'                   => 'Error: a language with this abbreviation already exists!',
    'LANGUAGE_EMPTYLANGUAGENAME_ERROR'               => 'Please enter language name!',
    'LANGUAGE_ABBREVIATION_INVALID_ERROR'            => 'Language abbreviation invalid! Permitted characters are a-z, A-Z, 0-9 and the underscore.',
    'SETUP_DIRNOTDELETED_WARNING'                    => 'Please delete directory: Setup!',
    'UPDATEAPP_DIRNOTDELETED_WARNING'                => 'Please delete directory: updateApp!',
    'SETUP_CONFIGPERMISSIONS_WARNING'                => 'Due to security reasons put your config.inc.php file to read-only mode!',
    'LOGIN_TITLE'                                    => 'OXID eShop Login',
    'LOGIN_ERROR'                                    => 'Error! Incorrect username and/or password!',
    'LOGIN_NO_COOKIE_SUPPORT'                        => 'Error! Your browser does not support cookies!',
    'LOGIN_LANGUAGE'                                 => 'Language',
    'LOGIN_PROFILE'                                  => 'Profile',
    'LOGIN_START'                                    => 'Start OXID eShop Admin',
    'LOGIN_STAGINGMODE_NOTIFY'                       => 'Functionality is limited in staging mode',
    'LOGIN_DEMOMODE_NOTIFY'                          => 'Functionality is limited in demoshop mode',
    'MAIN_TITLE'                                     => '[OXID Startpage]',
    'MAIN_INFO'                                      => 'Information',
    'MR'                                             => 'Mr',
    'MRS'                                            => 'Mrs',
    'HOME_DESC'                                      => 'Welcome to the OXID eShop Admin. This is an overview of the main areas and functions.',
    'NAVIGATION_TITLE'                               => 'Navigation',
    'NAVIGATION_ESHOPADMIN'                          => 'eShop Admin',
    'NAVIGATION_LOGOUT'                              => 'Logout',
    'NAVIGATION_HOME'                                => 'Home',
    'NAVIGATION_PAGE'                                => 'Page',
    'NAVIGATION_NEWVERSIONAVAILABLE'                 => 'Version %s is available.',
    // @deprecated since v.5.3.0 (2016-06-17); The Admin Menu: Customer Info -> News feature will be moved to a module in v6.0.0
    'NEWS_LIST_TITLE'                                => '[OXID News Administration]',
    'NEWS_LIST_SHORTTEXT'                            => 'Title',
    'NEWS_LIST_MENUITEM'                             => 'Customer Information',
    'NEWS_LIST_MENUSUBITEM'                          => 'News',
    'NEWS_MAIN_SHORTDESC'                            => 'Title',
    'NEWS_MAIN_SHOWFORGROUP'                         => 'Visible for User Group',
    'NEWS_MAIN_NOTSHOWFORGROUP'                      => 'Invisible for User Group',
    // END deprecated
    'NAVIGATION_FAVORITES'                           => 'Favorites',
    'NAVIGATION_FAVORITES_EDIT'                      => '[ edit ]',
    'FAVORITES_DESC'                                 => 'favorites description ...',
    'NAVIGATION_HISTORY'                             => 'History',
    'NAVIGATION_SYSREQ_MESSAGE'                      => "System health check shows setup/server setup of this OXID eShop might be broken. Probably this OXID eShop behaves strange in some cases. Please fix this as soon as possible. Support for fixing find in ",
    'NAVIGATION_SYSREQ_MESSAGE2'                     => "<b>system health check</b>.",
    'NAVIGATION_SYSREQ_MESSAGE_INACTIVE'             => "The permanent system health check has been deactivated. You can re-activate it in the Perform. tab at Master settings -> Core settings. To check it anyway, please click on this link: ",
    'NAVIGATION_SHOPFRONT'                           => "Shop's start page",

    'NEWSLETTER_DONE_NEWSSEND'                           => 'Your Newsletter has been sent.',
    'NEWSLETTER_DONE_GOTONEWSLETTER'                     => 'go to Newsletter ',
    'NEWSLETTER_DONE_TITLE'                              => 'OXID Newsletter',
    'NEWSLETTER_LIST_MENUITEM'                           => 'Customer Information',
    'NEWSLETTER_LIST_MENUSUBITEM'                        => 'Newsletter',
    'NEWSLETTER_MAIN_MODEL'                              => 'Sample',
    'NEWSLETTER_PLAIN_TEXT'                              => 'Plain Text Sample',
    'NEWSLETTER_PREVIEW_PLAINTEXT'                       => 'PLAIN TEXT',
    'NEWSLETTER_PREVIEW_HTML'                            => 'HTML',
    'NEWSLETTER_SELECTION_USEDGROUP'                     => 'Used User Groups: ',
    'NEWSLETTER_SELECTION_SELMAILRESAVER'                => 'Selected e-mail recipients',
    'NEWSLETTER_SELECTION_SENDNEWS'                      => 'Send Newsletter',
    'NEWSLETTER_SEND_TITLE'                              => 'OXID Newsletter',
    'NEWSLETTER_SEND_SEND1'                              => 'Send',
    'NEWSLETTER_SEND_SEND2'                              => 'of overall',
    'ORDER_ARTICLE_YOUWANTTODELETE'                      => 'Do you really want to delete this product?',
    'ORDER_ARTICLE_YOUWANTTOSTORNO'                      => 'Do you really want to cancel this product?',
    'ORDER_ARTICLE_ENETTO'                               => 'Net',
    'ORDER_ARTICLE_EBRUTTO'                              => 'Gross',
    'ORDER_ARTICLE_MWST'                                 => 'VAT',
    'ORDER_ARTICLE_ADDITEM'                              => 'Add Product',
    'ORDER_ARTICLE_SEARCH'                               => 'Search',
    'ORDER_ARTICLE_SEARCH_NOITEMSFOUND'                  => 'Sorry, no items found.',
    'ORDER_ARTICLE_PARAMS'                               => 'Parameter',
    'ORDER_ARTICLE_STORNO'                               => 'Order is canceled',
    'ORDER_ARTICLE_UPDATE_STOCK'                         => 'Update',
    'ORDER_DOWNLOADS_FILE'                               => 'Downloadable file',
    'ORDER_DOWNLOADS_FIRSTDOWNLOAD'                      => 'First download',
    'ORDER_DOWNLOADS_LASTDOWNLOAD'                       => 'Last download',
    'ORDER_DOWNLOADS_COUNTOFDOWNLOADS'                   => 'Count of downloads',
    'ORDER_DOWNLOADS_MAXCOUNT'                           => 'Max. count of downloads',
    'ORDER_DOWNLOADS_EXPIRATIONTIME'                     => 'Valid until',
    'ORDER_DOWNLOADS_COUNTOFRESETS'                      => 'Count of resets',
    'ORDER_DOWNLOADS_RESET'                              => 'Reset',
    'ORDER_SEARCH_FIELD_ARTID'                           => 'Product',
    'ORDER_SEARCH_FIELD_PAYMENT'                         => 'Payment',
    'ORDER_LIST_YOUWANTTOSTORNO'                         => 'Do you really want to cancel this order?',
    'ORDER_LIST_FOLDER_ALL'                              => 'all',
    'ORDER_LIST_ORDERTIME'                               => 'Order Time',
    'ORDER_LIST_PAID'                                    => 'Payment Date',
    'ORDER_LIST_CUSTOMERFNAME'                           => 'First Name',
    'ORDER_LIST_CUSTOMERLNAME'                           => 'Last Name',
    'ORDER_LIST_MENUITEM'                                => 'Administer Orders',
    'ORDER_LIST_MENUSUBITEM'                             => 'Orders',
    'ORDER_MAIN_IPADDRESS'                               => 'IP Address',
    'ORDER_MAIN_BILLNUM'                                 => 'Invoice No.',
    'ORDER_MAIN_TRACKCODE'                               => 'Tracking Code',
    'ORDER_MAIN_TRACKCODE_LINK'                          => 'Tracking Link',
    'ORDER_MAIN_DISCOUNT'                                => 'Discount',
    'ORDER_MAIN_PAIDON'                                  => 'Paid on',
    'ORDER_MAIN_USERVOUCHER'                             => 'Used Coupon',
    'ORDER_MAIN_PAIDWITH'                                => 'Payment with',
    'ORDER_MAIN_ORDERPAID'                               => 'Order was paid',
    'ORDER_MAIN_CURRENT_DATE'                            => 'Current Date',
    'ORDER_MAIN_DELTYPE'                                 => 'Shipped with',
    'ORDER_MAIN_UPDATE_DELPAY'                           => 'Update',
    'ORDER_MAIN_SEND_DOWNLOADS'                          => 'Ordered download links',
    'ORDER_MAIN_PAYMENT_INFORMATION'                     => "Payment Information",
    'ORDER_MAIN_SHIPPING_INFORMATION'                    => "Shipping Information",
    'ORDER_REMARK_REMARK'                                => '[Remark]',
    'ORDER_REMARK_ORDER'                                 => '[Order]',
    'ORDER_REMARK_USER'                                  => '[Reg.]',
    // @deprecated since v.5.3.0 (2016-06-17); The Admin Menu: Customer Info -> News feature will be moved to a module in v6.0.0
    'ORDER_REMARK_NEWS'                                  => '[News]',
    // END deprecated
    'ORDER_OVERVIEW_VATIDCHECKFAIL'                      => 'VAT ID validation failed',
    'ORDER_OVERVIEW_VATID'                               => 'VAT ID',
    'ORDER_OVERVIEW_DELTYPE'                             => 'Shipped with',
    'ORDER_OVERVIEW_LSBANKNAME'                          => 'Bank',
    'ORDER_OVERVIEW_LSBLZ'                               => 'Bank code (or BIC)',
    'ORDER_OVERVIEW_LSKTONR'                             => 'Account No. (or IBAN)',
    'ORDER_OVERVIEW_LSKTOINHABER'                        => 'Account Holder',
    'ORDER_OVERVIEW_INFOLDER'                            => 'In Folder',
    'ORDER_OVERVIEW_INTSTATUS'                           => 'Internal Status',
    'ORDER_OVERVIEW_ORDERAMTODAY'                        => 'Number Orders Today',
    'ORDER_OVERVIEW_ORDERSUMTODAY'                       => 'Sum Revenue Today',
    'ORDER_OVERVIEW_ORDERAMTOTAL'                        => 'Number Order TOTAL',
    'ORDER_OVERVIEW_ORDERSUMTOTAL'                       => 'Sum Revenue TOTAL',
    'ORDER_OVERVIEW_PAYMENTTYPE'                         => 'Payment with',
    'ORDER_OVERVIEW_STORNO'                              => 'Order is canceled',
    'ORDER_OVERVIEW_PDF'                                 => 'Create PDF',
    'ORDER_OVERVIEW_MAKE'                                => 'Create',
    'ORDER_OVERVIEW_PDF_TYPE'                            => 'PDF type',
    'ORDER_OVERVIEW_PDF_STANDART'                        => 'Invoice',
    'ORDER_OVERVIEW_PDF_DNOTE'                           => 'Deliv. Note',
    'WRAPPING_COSTS'                                     => 'Gift Wrapping',
    'GIFTCARD_COSTS'                                     => 'Greeting Card',
    'ORDERFOLDER_NEW'                                    => 'New',
    'ORDERFOLDER_FINISHED'                               => 'Finished',
    'ORDERFOLDER_PROBLEMS'                               => 'Problems',
    'PAGENAVISNIPPET_FROM'                               => 'from',
    'PAYMENT_COUNTRY_ALLCOUNTRIES'                       => 'All Countries',
    'PAYMENT_COUNTRY_SELCOUNTRIES'                       => 'Assigned Countries',
    'PAYMENT_LIST_MENUITEM'                              => 'Shop Settings',
    'PAYMENT_LIST_MENUSUBITEM'                           => 'Payment Methods',
    'PAYMENT_MAIN_ADDPRICE'                              => 'Price Surcharge/Reduction',
    'PAYMENT_MAIN_ADDSUMRULES'                           => 'Base of price <br>surcharge/reduction',
    'PAYMENT_MAIN_ADDSUMRULES_ALLGOODS'                  => '1. Value of all goods in cart',
    'PAYMENT_MAIN_ADDSUMRULES_DISCOUNTS'                 => '2. Discounts',
    'PAYMENT_MAIN_ADDSUMRULES_VOUCHERS'                  => '3. Vouchers',
    'PAYMENT_MAIN_ADDSUMRULES_SHIPCOSTS'                 => '4. Shipping costs',
    'PAYMENT_MAIN_ADDSUMRULES_GIFTS'                     => '5. Gift Wrapping/Greeting Card',
    'PAYMENT_MAIN_NAME'                                  => 'Name',
    'PAYMENT_MAIN_FROMBONI'                              => 'min. Credit Rating',
    'PAYMENT_MAIN_AMOUNT'                                => 'Purchase Price',
    'PAYMENT_MAIN_FROM'                                  => 'from',
    'PAYMENT_MAIN_TILL'                                  => 'to',
    'PAYMENT_MAIN_SELECTED'                              => 'Selected',
    'PAYMENT_MAIN_AVAILIBLEINGROUP'                      => 'Available in User Groups',
    'PAYMENT_MAIN_NOTAVAILIBLEINGROUP'                   => 'Not available in User Groups',
    'PAYMENT_MAIN_LONGDESC'                              => 'Payment Description',
    'PAYMENT_MAIN_NOTICEDEFAULTVALUESSELECTED'           => 'Default values have been selected',
    'PAYMENT_OVERVIEW_HOWMANYPAYMENTS'                   => 'How many purchases were paid with this payment method',
    'PRICEALARM_DONE_SENDEMAIL'                          => 'Sent Price Alert e-mails.',
    'PRICEALARM_DONE_GOTOPRICEALARM'                     => 'go to Price Alert ',
    'PRICEALARM_LIST_CONFIRMDATE'                        => 'Confirmation Date',
    'PRICEALARM_LIST_SENDDATE'                           => 'Shipping Date',
    'PRICEALARM_LIST_CUSTOMERSPRICE'                     => 'Cust. Price',
    'PRICEALARM_LIST_STANDARTPRICE'                      => 'Reg. Price',
    'PRICEALARM_LIST_MENUITEM'                           => 'Customer Information',
    'PRICEALARM_LIST_MENUSUBITEM'                        => 'Price Alert',
    'PRICEALARM_MAIL_OXIDPRICEALARM'                     => 'OXID eSales Price Alert',
    'PRICEALARM_MAIL_OPENEMAILS1'                        => 'There are',
    'PRICEALARM_MAIL_OPENEMAILS2'                        => 'Price Alert e-mails open and ready to be send.',
    'PRICEALARM_MAIL_SENDPRICEALARMEMAIL1'               => 'To send the Price Alert e-mails to the customers please',
    'PRICEALARM_MAIL_SENDPRICEALARMEMAIL2'               => 'click here.',
    'PRICEALARM_MAIN_SUCCESS'                            => 'E-mail has been sent successfully',
    'PRICEALARM_MAIN_ERROR'                              => 'Error sending e-mail',
    'PRICEALARM_MAIN_EMAIL'                              => 'E-mail',
    'PRICEALARM_MAIN_CUSTOMER'                           => 'Customer',
    'PRICEALARM_MAIN_SUBSCRIPTIONDATE'                   => 'Subscription Date',
    'PRICEALARM_MAIN_MAILINGDATE'                        => 'Shipping Date',
    'PRICEALARM_MAIN_PRODUCT'                            => 'Product',
    'PRICEALARM_MAIN_CUSTOMERPRICE'                      => 'Customer Price',
    'PRICEALARM_MAIN_REGULARPRICE'                       => 'Regular Price',
    'PRICEALARM_MAIN_EMAILSEND'                          => 'Send e-mail',
    'PRICEALARM_SEND_TITLE'                              => 'oxid Price Alert',
    'PRICEALARM_MESSAGE_SENT'                            => 'Sent',
    'PRICEALARM_SEND_FROM'                               => 'from',
    'ROLES_LIST_TITLE'                                   => 'Title',
    'ROLES_FEMAIN_SAVE'                                  => 'Save',
    'ROLES_FEMAIN_TITLE'                                 => 'Title',
    'ROLES_FEMAIN_NEWFIELD'                              => 'Add field',
    'ROLES_FEMAIN_UIHEADER'                              => 'Ident (parameters)',
    'ROLES_FEMAIN_UIHEADERRIGHT'                         => 'V',
    'ROLES_FEMAIN_UIEXAMPLE'                             => 'Example: <i>IDENT[&class1;class2;function1;function2...]</i>',
    'ROLES_FEMAIN_UITPLEXAMPLE'                          => 'Usage in template: <i>[{ oxhasrights ident=\"IDENT\" }] ... [{ /oxhasrights }]</i>',
    'ROLES_FEMAIN_UIINFO'                                => 'rights: (V)Exclusively viewable (executable)',
    'ROLES_FEMAIN_ACTIVE'                                => 'Active',
    'ROLES_BEMAIN_TITLE'                                 => 'Title',
    'ROLES_BEMAIN_UIINFO'                                => '(F)ull, (R)ead, (D)eny, (I)nsert, (X)Delete, (C)ustomized',
    'ROLES_BEMAIN_ACTIVE'                                => 'Active',
    'ROLES_BEMAIN_UIROOTHEADER'                          => 'Menu',
    'ROLES_BEMAIN_UIRIGHT_F'                             => 'F',
    'ROLES_BEMAIN_UIRIGHT_R'                             => 'R',
    'ROLES_BEMAIN_UIRIGHT_D'                             => 'D',
    'ROLES_BEMAIN_UIRIGHT_X'                             => 'X',
    'ROLES_BEMAIN_UIRIGHT_I'                             => 'I',
    'ROLES_BEMAIN_UIRIGHT_CUST'                          => 'C',
    'ROLES_BEOBJECT_OBJECTS'                             => 'Object rights',
    'SELECTLIST_LIST_MENUSUBITEM'                        => 'Selection Lists',
    'SELECTLIST_MAIN_FIELDS'                             => 'Fields',
    'SELECTLIST_MAIN_TITLEIDENT'                         => 'Working Title',
    'SELECTLIST_MAIN_ADDFIELD_NAME'                      => 'Name',
    'SELECTLIST_MAIN_ADDFIELD_PREIS'                     => 'Price Surcharge/<br />Discount',
    'SELECTLIST_MAIN_ADDFIELD_POS'                       => 'Sorting',
    'SELECTLIST_MAIN_CHOSENITEMSLIST'                    => 'All Lists this Product uses',
    'SELECTLIST_MAIN_ITEMSWITHCHOSLIST'                  => 'Products using this List',
    'SHOP_CACHE_FLUSH'                                   => 'Flush cache',
    'SHOP_CACHE_TITLE'                                   => 'Dynamic Content Caching',
    'SHOP_CACHE_ENABLED'                                 => 'Enable caching',
    'SHOP_CACHE_HIT_STATS'                               => 'Cache Hit [count/ratio/percent]',
    'SHOP_CACHE_MISS_STATS'                              => 'Cache Miss [count/ratio/percent]',
    'SHOP_CACHE_COUNT_STATS'                             => 'Cache Count [Valid/Expired/Total]',
    'SHOP_CACHE_SIZE_STATS'                              => 'Cache Size [Valid/Expired/Total]',
    'SHOP_CACHE_BACKEND'                                 => 'Selected cache backend',
    'SHOP_CACHE_BACKEND_ZS_SHM'                          => 'Zend Data Cache Shared Memory Storage',
    'SHOP_CACHE_BACKEND_ZS_DISK'                         => 'Zend Data Cache Disk Storage',
    'SHOP_CACHE_BACKEND_OXID'                            => 'OXID eShop Disk Storage Cache',
    'SHOP_CACHE_LIFETIME'                                => 'Cache lifetime (TTL)',
    'SHOP_CACHE_CLASSES'                                 => 'Cachable classes',
    'SHOP_CACHE_AVAILABLE_FOR_NON_PRODUCTIVE'            => 'Available in non-productive mode only',
    'SHOP_CACHE_CONTENT_CACHE_FLUSH'                     => 'Flush cache',
    'SHOP_CACHE_DEFAULT_BACKEND_ACTIVE'                  => 'Enable caching',
    'SHOP_CACHE_DEFAULT_BACKEND_TTL'                     => 'Cache lifetime (TTL)',
    'SHOP_CACHE_DEFAULT_BACKEND_CONNECTOR'               => 'Cache connector',
    'SHOP_CACHE_CONNECTOR_oxMemcachedCacheConnector'     => 'Memcached',
    'SHOP_CACHE_CONNECTOR_oxZendShmCacheConnector'       => 'Zend shared memory',
    'SHOP_CACHE_CONNECTOR_oxZendDiskCacheConnector'      => 'Zend disk',
    'SHOP_CACHE_CONNECTOR_oxFileCacheConnector'          => 'File system',
    'SHOP_CACHE_DEFAULT_MEMCACHED_SERVERS'               => 'List of Memcached servers ([host]@[port]@[weight])',
    'SHOP_CACHE_DEFAULT_CACHE_DIR'                       => 'Cache directory',
    'SHOP_CACHE_DEFAULT_BACKEND_FLUSH'                   => 'Flush cache',
    'SHOP_CACHE_REVERSE_PROXY_FLUSH'                     => 'Flush cache',
    'SHOP_CACHE_REVERSE_PROXY_ACTIVE'                    => 'Enable caching',
    'SHOP_CACHE_REVERSE_PROXY_SECTION_ALL'               => 'All',
    'SHOP_CACHE_REVERSE_PROXY_SECTION_START'             => 'Start page',
    'SHOP_CACHE_REVERSE_PROXY_SECTION_DETAILS'           => 'Details pages',
    'SHOP_CACHE_REVERSE_PROXY_SECTION_LISTS'             => 'List and details pages',
    'SHOP_CACHE_LAYOUT_CACHE_AGE'                        => 'Cache lifetime (TTL)',
    'SHOP_CACHE_GROUP_DEFAULT_BACKEND'                   => 'Default Cache Backend',
    'SHOP_CACHE_GROUP_REVERSE_PROXY'                     => 'Reverse Proxy',
    'SHOP_CACHE_GROUP_CONTENT_CACHE'                     => 'Dynamic Content Caching',
    'SHOP_CACHE_WARNING_CONTENTCACHE_ENABLED'            => 'We recommend to not use "Dynamic Content Caching" and "Reverse Proxy" at the same time, as it could slow down the performance.',
    'SHOP_CACHE_ENABLE_CACHE'                            => 'Are you sure you want to enable it?',
    'SHOP_MALL_SHOPURL'                                  => 'Shop URL',
    'SHOP_MALL_SHOPSSLSHOPURL'                           => 'Shop SSL URL',
    'SHOP_MALL_NATIVEIMAGES'                             => 'Load /out directory from active shop',
    'SHOP_MALL_NOSTARTSITE'                              => 'Show main shop front page',
    'SHOP_MALL_STARTSITE'                                => 'Show shop selector',
    'SHOP_MALL_MALLMODE'                                 => 'Start page type',
    'SHOP_MALL_MALLUSERS'                                => 'Allow users from other shops',
    'SHOP_MALL_SEPARATENUMBERING'                        => 'Separate shop order numbering',
    'SHOP_MALL_PRICEADDITION'                            => 'Product price addition to base price',
    'SHOP_MALL_MALLCUSTOMPRICE'                          => 'Allow custom price editing for inherited products',
    'SHOP_MALL_UPDATEVIEWSINFO'                          => 'After particular DB table structure updates, in order changes to take effect you need to regenerate DB views.',
    'SHOP_MALL_UPDATEVIEWSNOW'                           => 'Update DB Views now',
    'SHOP_MALL_UPDATEVIEWSCONFIRM'                       => 'Are you sure you want to update views now?',
    'SHOP_MALL_MALLINHERITANCE'                          => 'Default inheritance from parent shop',
    'SHOP_MALL_MALLINHERIT_OXARTICLES'                   => 'Inherit all <b>products</b> from parent shop',
    'SHOP_MALL_MALLINHERIT_OXATTRIBUTES'                 => 'Inherit all <b>attributes</b> from parent shop',
    'SHOP_MALL_MALLINHERIT_OXDELIVERY'                   => 'Inherit <b>delivery information</b> from parent shop',
    'SHOP_MALL_MALLINHERIT_OXDISCOUNT'                   => 'Inherit all <b>discounts</b> from parent shop',
    'SHOP_MALL_MALLINHERIT_OXLINKS'                      => 'Inherit all <b>shop links</b> from parent shop',
    'SHOP_MALL_MALLINHERIT_OXVOUCHERSERIES'              => 'Inherit all <b>coupon series</b> from parent shop',
    // @deprecated since v.5.3.0 (2016-06-17); The Admin Menu: Customer Info -> News feature will be moved to a module in v6.0.0
    'SHOP_MALL_MALLINHERIT_OXNEWS'                       => 'Inherit <b>shop news</b> from parent shop',
    // END deprecated
    'SHOP_MALL_MALLINHERIT_OXSELECTLIST'                 => 'Inherit all <b>select lists</b> from parent shop',
    'SHOP_MALL_MALLINHERIT_OXVENDOR'                     => 'Inherit all <b>distributors</b> from parent shop',
    'SHOP_MALL_MALLINHERIT_OXMANUFACTURER'               => 'Inherit all <b>manufacturers</b> from parent shop',
    'SHOP_MALL_MALLINHERIT_OXWRAPPING'                   => 'Inherit <b>wrapping information</b> from parent shop',
    'SHOP_MALL_MALLINHERIT_OXCATEGORIES'                 => 'Inherit all <b>categories</b> from all shops',
    'SHOP_MALL_SAVE_INHERITANCE'                         => 'Save inheritance information',
    'SHOP_MAIN_ISINHERITED'                              => 'Shop inherits all inheritable items (products, discounts etc) from it\'s parent shop.',
    'SHOP_MAIN_ISMULTISHOP'                              => 'Shop is multishop (loads all products from all shops)',
    'SHOP_MAIN_ISSUPERSHOP'                              => 'Shop is supershop (you can assign products to any shop).',
    'SHOP_MAIN_ID'                                       => 'Shop ID',
    'SHOP_MAIN_SHOPPARENT'                               => 'Shop Parent',
    'SHOP_MAIN_MANDATE_WARNING'                          => 'Attention: Maximum mandate count is exceeded, please, contact OXID eSales for more information!',
    'SHOP_MAIN_MAXSHOP_WARNING'                          => 'Attention: Maximum shop count is exceeded, please, contact OXID eSales for more information!',
    'SHOP_MAIN_NEWSHOP_WARNING'                          => 'Attention: Creating this sub shop you have to update views, otherwise shops will not work! While generating views, the performance of OXID eShop could be affected.',
    'SHOP_MAIN_FORGOTPWDSUBJECT'                         => 'Forgot Password e-mail Subject',
    'SHOP_MAIN_INFOEMAIL'                                => 'Info e-mail Address',
    'SHOP_MAIN_SENT_NOW_SUBJECT'                         => 'Shipped now e-mail Subject',
    'SHOP_MAIN_ORDEREMAIL'                               => 'Order e-mail reply',
    'SHOP_MAIN_OWNEREMAIL'                               => 'Order e-mails to ',
    'SHOP_MAIN_ORDERSUBJECT'                             => 'Order e-mail Subject',
    'SHOP_MAIN_REGISTERSUBJECT'                          => 'Registration e-mail Subject',
    'SHOP_MAIN_SELECTSHOP'                               => 'Please select Shop.',
    'SHOP_MAIN_SHOPNAME'                                 => 'eShop Name',
    'SHOP_MAIN_SMTPSERVER'                               => 'SMTP Server',
    'SHOP_MAIN_SMTPUSER'                                 => 'SMTP User',
    'SHOP_MAIN_SMTPPASSWORD'                             => 'SMTP Password',
    'SHOP_MAIN_SMTPPWUNSET'                              => 'Enter "-" to unset',
    'SHOP_MAIN_BANKNAME'                                 => 'Bank Name',
    'SHOP_MAIN_BANKCODE'                                 => 'Routing Number',
    'SHOP_MAIN_BANKNUMBER'                               => 'Account Number',
    'SHOP_MAIN_BICCODE'                                  => 'Bank BIC',
    'SHOP_MAIN_COMPANY'                                  => 'Company Name',
    'SHOP_MAIN_COURT'                                    => 'District Court',
    'SHOP_MAIN_HRBNR'                                    => 'CRB',
    'SHOP_MAIN_IBANNUMBER'                               => 'Bank IBAN',
    'SHOP_MAIN_VATNUMBER'                                => 'Sales Tax ID',
    'SHOP_MAIN_TAXNUMBER'                                => 'Tax ID',
    'SHOP_MAIN_PRODUCTIVE'                               => 'Productive Mode',

    'SHOP_CONFIG_ALLOW_USERS_MANAGE_REVIEWS'                  => 'Allow shop users to manage their reviews',
    'SHOP_CONFIG_ALLOW_USERS_TO_DELETE_THEIR_ACCOUNT'         => 'Allow shop users to delete their account',
    'SHOP_CONFIG_CSVSEPARATOR'                                => 'CSV Separation Char for Im/Export',
    'SHOP_CONFIG_CSVFIELDENCLOSER'                            => 'CSV-Encloser for Im/Export',
    'SHOP_CONFIG_DISABLEARTDUBLICATES'                        => 'When Products are copied: Do not set copied Product to active',
    // @deprecated since v6.2.0 (2017-02-15); Recommendations feature will be moved to an own module.
    'SHOP_CONFIG_ALLOW_SUGGEST_ARTICLE'                       => 'Allow the recommendation of products',
    // END deprecated
    'SHOP_CONFIG_EXPORTNUMBEROFLINES'                         => 'Number of Lines which are exported per Tick in CSV Export',
    'SHOP_CONFIG_MWSTSETTING'                                 => 'VAT Settings for XML export',
    'SHOP_CONFIG_NUMBEROFEMAILSPERTICK'                       => 'Number of Newsletters sent per Tick',
    'SHOP_CONFIG_UPDATEVIEWS'                                 => 'Database views needs to be updated!',
    'SHOP_CONFIG_ASSIGNDEFAULTCAT'                            => 'Assign default category',
    'SHOP_CONFIG_UNASSIGNDEFAULTCAT'                          => 'Unassign default category',
    'SHOP_CONFIG_ASSIGNEDDEFAULTCAT'                          => 'Default category:',
    'SHOP_CONFIG_ACTIVECATEGORYBYSTART'                       => 'Active Category at Start',
    'SHOP_CONFIG_AUTOSEARCHONCAT'                             => 'Start Search automatically if User selects a Category',
    'SHOP_CONFIG_AUTOICONS'                                   => 'Generate Icons automatically from Thumbnails (might slow down your server)',
    'SHOP_CONFIG_ALLOWUNEVENAMOUNTS'                          => 'Allow fraction Quantities (e.g. 1.5)',
    'SHOP_CONFIG_BIDIRECTCROSS'                               => 'Enable bidirectional Crosselling',
    'SHOP_CONFIG_CONFIRMAGB'                                  => 'Users have to Confirm General Terms and Conditions during Check-Out',
    'SHOP_CONFIG_ENABLE_INTANGIBLE_PRODUCTS_AGREEMENT'        => 'Users have to confirm terms and conditions for downloadable and intangible products during the check-out',
    'SHOP_CONFIG_SHOWORDERBUTTONONTHETOP'                     => 'Show an additional "Order now" button at the top in 4th order step (by default "Order now" button is shown only on the bottom of the page).',
    'SHOP_CONFIG_CALCULATEVATFORDELIVERY'                     => 'Display shipping costs as net price and VAT (instead of gross) in shopping cart and invoice',
    'SHOP_CONFIG_CALCDELVATONTOP'                             => 'Enter Shipping Costs as net Price (plus VAT)',
    'SHOP_CONFIG_CALCULATEVATFORWRAPPING'                     => 'Display VAT contained in Gift Wrappings and Greeting Cards in Shopping Cart and Invoice',
    'SHOP_CONFIG_CALCWRAPVATONTOP'                            => 'Enter Gift Wrapping and Greeting Card Prices as net Price (plus VAT)',
    'SHOP_CONFIG_CALCULATEVATOFORPAYCHARGE'                   => 'Display VAT contained in Payment Method Charges in Shopping Cart and Invoice',
    'SHOP_CONFIG_CALCPAYVATONTOP'                             => 'Enter Payment Method Charges as net Price (plus VAT)',
    'SHOP_CONFIG_CMSFOLDER'                                   => 'CMS Page Folders',
    // @deprecated since v.5.3.0 (2016-06-17); The Admin Menu: Customer Info -> News feature will be moved to a module in v6.0.0
    'SHOP_CONFIG_CNTOFNEWS'                                   => 'Number of News which are displayed in the News Box',
    // END deprecated
    'SHOP_CONFIG_DATEFORMAT'                                  => 'Date Format in eShop Admin',
    'SHOP_CONFIG_DELIVERYCOSTS'                               => 'Calculate default Shipping costs when User is not logged in yet',
    'SHOP_CONFIG_DEFAULTVAT'                                  => 'Default VAT for all Products',
    'SHOP_CONFIG_DEFAULTLANGUAGE'                             => 'Default Language (0, 1, 2 ...) - 0 for German, 1 for English',
    'SHOP_CONFIG_EXCLUDENONMATERIALPRODUCTS'                  => "Don't consider intangible Products (e.g. Gift Certificates) in Shipping Costs Calculation",
    'SHOP_CONFIG_ENTERNETPRICE'                               => 'Enter Product Prices as Net Prices (plus VAT)',
    'SHOP_CONFIG_VIEWNETPRICE'                                => 'Show net prices in frontend (B2B)',
    'SHOP_CONFIG_INLANDCUSTOMERS'                             => 'Domestic Customers - Customers living in the <b>selected</b> Countries are assigned to the User Group "Domestic Customers". For multiple selections use CTRL key.',
    'SHOP_CONFIG_LARGECUSTOMERPRICE'                          => 'Purchase Price Threshold from which Users are assigned to User Group "Huge Turnover"',
    'SHOP_CONFIG_MIDLLECUSTOMERPRICE'                         => 'Purchase Price Threshold from which Users are assigned to User Group "Medium Turnover"',
    'SHOP_CONFIG_MINORDERPRICE'                               => 'Min. Order Price (leave empty to disable)',
    'SHOP_CONFIG_MUSTFILLFIELDS'                              => 'Mandatory fields in User Registration Form',
    'SHOP_CONFIG_NEWARTBYINSERT'                              => 'Calculate newest Products by Date of Creation (otherwise by Date of last Change)',
    'SHOP_CONFIG_NROFCATARTICLES'                             => 'Number of Products which can be shown in a Product List (Category Pages, Search Results)<br>Attention: A large number of products per page (above 100) can cause serious performance issues!',
    'SHOP_CONFIG_NROFCUSTOMERWHOARTICLES'                     => 'Number of Products which are shown in "Customers who bought this product also purchased:"',
    'SHOP_CONFIG_NROFNEWCOMERARTICLES'                        => 'Number of Products which are shown in "Just arrived!" (newest Products)',
    'SHOP_CONFIG_NUMBEROFSIMILARARTICLES'                     => 'Number of similar Products which are shown with a Product',
    'SHOP_CONFIG_NUMBEROFCROSSSELLARTICLES'                   => 'Number of Crossselling Products and Accessories which are shown with a Product',
    'SHOP_CONFIG_ORDERFOLDER'                                 => 'Folders in Order Administration',
    'SHOP_CONFIG_OVERRIDEZEROABCPRICES'                       => 'Use standard Product Price if no A/B/C Price is set',
    'SHOP_CONFIG_ORDEROPTINEMAIL'                             => 'Activate Double Opt-In if Users register for Newsletter',
    'SHOP_CONFIG_SORTITEMSLIST'                               => 'Users can sort Product Lists',
    'SHOP_CONFIG_SORTFIELDS'                                  => 'Database Fields Product Lists can be sorted after',
    'SHOP_CONFIG_SEARCHFIELDS'                                => 'Fields to be considered in Search',
    'SHOP_CONFIG_SEARCHUSEAND'                                => 'If several Search Terms are entered, all Search Terms have to be found in Search Results (AND). (If this Setting is unchecked, only one Search Term has to be found (OR)',
    'SHOP_CONFIG_SETORDELETECURRENCY'                         => 'Add or remove currencies.',
    'SHOP_CONFIG_SETORDELETELANGUAGE'                         => 'Add or remove languages.',
    'SHOP_CONFIG_SETORDELETELANGUAGEURL'                      => "Language dependent Base URL's per language (optional). Enter one URL per line. The first URL is used for the first language, the second URL for the second language and so on. An example:<br />http://www.youreshop.de/<br />http://www.youreshop.com/",
    'SHOP_CONFIG_SETORDELETELANGUAGESSLURL'                   => "Language dependent Base SSL URL's per language (optional). Enter one URL per line. The first URL is used for the first language, the second URL for the second language and so on. An example:<br />https://www.yourssleshop.de/<br />https://www.yourssleshop.com/",
    'SHOP_CONFIG_SHIPPINGCOUNTRYVAT'                          => 'Use shipping country for VAT calculation instead of billing country',
    'SHOP_CONFIG_STOCKWARNINGLIMIT'                           => 'Stock Level at which Users are informed that only a few Products remain in Stock',
    'SHOP_CONFIG_STOCKOFFDEFAULTMESSAGE'                      => 'Use default "out-of-stock" Message',
    'SHOP_CONFIG_STOCKONDEFAULTMESSAGE'                       => 'Use default "in-stock" Message',
    'SHOP_CONFIG_STORECREDITCARDINFO'                         => 'Save Credit Card information',
    'SHOP_CONFIG_SHOWTSINTERNATIONALFEESMESSAGE'              => 'Display a message about possible international delivery fees',
    'SHOP_CONFIG_SHOWTSCODMESSAGE'                            => 'Display a message about possible "cash on delivery" payment method fees',
    'SHOP_CONFIG_TIMEFORMAT'                                  => 'Time Format in eShop Admin',
    'SHOP_CONFIG_USEGDVERSION'                                => 'Installed GDLib Version',
    'SHOP_CONFIG_USESTOCK'                                    => 'Activate Stock Management',
    'SHOP_CONFIG_USENEGATIVESTOCK'                            => 'Allow negative Stock Values',
    'SHOP_CONFIG_WARNONSAMEARTNUMS'                           => 'Display Warning if a Product Number already exists',
    'SHOP_CONFIG_DELETERATINGLOGS'                            => 'How long product ratings are stored (in days)',
    'SHOP_CONFIG_RSSITEMSCOUNT'                               => 'Number of Elements which are shown in RSS Feeds',
    'SHOP_CONFIG_RSSSELECTED'                                 => 'Shown RSS feeds',
    'SHOP_CONFIG_RSSTOPSHOP'                                  => 'Top of the Shop',
    'SHOP_CONFIG_RSSBARGAIN'                                  => 'Bargain',
    'SHOP_CONFIG_RSSNEWEST'                                   => 'Newest Products',
    'SHOP_CONFIG_RSSCATEGORIES'                               => 'Categories',
    'SHOP_CONFIG_RSSSEARCH'                                   => 'Search',
    'SHOP_CONFIG_RSSARTRECOMMLISTS'                           => 'Listmania (overview)',
    'SHOP_CONFIG_RSSRECOMMLISTARTS'                           => 'Listmania (products)',
    'SHOP_CONFIG_SEND_TECHNICAL_INFORMATION_TO_OXID'          => 'Allow a connection to OXID eSales servers for improving the quality of our open source products.',
    'SHOP_CONFIG_CHECK_UPDATES'                               => 'Check for available updates regularly',
    'SHOP_CONFIG_SELECTSHOPCOMPONENTS'                        => 'Select eShop components',
    'SHOP_CONFIG_DISABLEONLINEVATIDCHECK'                     => 'Disable online VAT ID check',
    'SHOP_CONFIG_ALTVATIDCHECKINTERFACEWSDL'                  => 'Alternative URL for online VAT ID check',
    'SHOP_CONFIG_PSLOGIN'                                     => 'Private Sales Login',
    'SHOP_CONFIG_DISABLE'                                     => 'Disable',
    'SHOP_CONFIG_ENABLE'                                      => 'Enable',
    'SHOP_CONFIG_BASKETEXCLUDE'                               => 'Cart exclusion',
    'SHOP_CONFIG_BASKETRESERVATION'                           => 'Cart expiration',
    'SHOP_CONFIG_BASKETRESERVATIONTIMEOUT'                    => 'Seconds cart expiration timeout',
    'SHOP_CONFIG_INVITATION'                                  => 'Invitation',
    'SHOP_CONFIG_POINTSFORINVITATION'                         => 'Credit points for inviting user',
    'SHOP_CONFIG_POINTSFORREGISTRATION'                       => 'Credit points for user registering after invitation',
    'SHOP_CONFIG_DOWNLOADS'                                   => 'Enable downloadable products',
    'SHOP_CONFIG_DOWNLOADS_PATH'                              => 'Path to files for downloadable products',
    'SHOP_CONFIG_CONFIRMCOOKIE'                               => 'Customers have to confirm the usage of cookies',
    'SHOP_CONFIG_DEBIT_OLD_BANK_INFORMATION_NOT_ALLOWED'      => 'Use IBAN/BIC only',
    'SHOP_CONFIG_PARCELSERVICE'                               => 'Shipping provider tracking URL',
    'SHOP_CONFIG_ERROR_INVALID_VALUE'                         => 'Provided configuration value: %s is not valid.',
    'SHOP_CONFIG_LOADREVIEWS'                                 => 'Activate user reviews and star ratings',
    'SHOP_CONFIG_INCLUDE_PRODUCT_REVIEW_LINKS_IN_ORDER_EMAIL' => 'Include a link  to product reviews in order e-mail',

    'SHOP_SYSTEM_ATTRIBUTESPERCENT'                      => 'Number of equal Attributes for similar Products (%)',
    'SHOP_SYSTEM_DEFAULTIMAGEQUALITY'                    => 'Picture Quality - from 0 (poor Quality, small File Size) to 100 (best Quality, large File Size)',
    'SHOP_SYSTEM_DISABLENAVBARS'                         => "Don't display most Navigation Elements during Checkout",
    'SHOP_SYSTEM_GBMODERATE'                             => ' Moderate Product Reviews: They are only published after they are activated by an Administrator User',
    'SHOP_SYSTEM_ISERVERTIMESHIFT'                       => 'Server Time shift (hours)',
    'SHOP_SYSTEM_INTERFACEPROFILES'                      => 'Admin Profiles (resolution / number of lines in list section)',
    'SHOP_SYSTEM_ORDERDISNOREG'                          => 'Disable Ordering without Registration.',
    'SHOP_SYSTEM_OTHERCOUNTRYORDER'                      => 'Allow Orders from foreign Countries if no Shipping Costs are defined',
    'SHOP_SYSTEM_SEARCHENGINEURLS'                       => "Static URL's. Important for optimal Product search-engine recognition, but doesn't work on all web-servers.",
    'SHOP_SYSTEM_SHOWVARIANTREVIEWS'                     => 'Show Variant Ratings for "Parent" Product',
    'SHOP_SYSTEM_STOREIPS'                               => 'Store User IP Addresses (check your local laws if legal)',
    'SHOP_SYSTEM_UTILMODULE'                             => 'Additional Utility Module',
    'SHOP_SYSTEM_VARIANTSSELECTION'                      => 'Display Variants in Assignment Lists in eShop admin',
    'SHOP_SYSTEM_VARIANTPARENTBUYABLE'                   => '"Parent" Products can be purchased',
    'SHOP_SYSTEM_VARIANTINHERITAMOUNTPRICE'              => 'Variants inherit Scale Prices from "Parent" Product',
    'SHOP_SYSTEM_USEMULTIDIMENSIONVARIANTS'              => 'Use multidimensional variants',
    'SHOP_SYSTEM_INLINEIMGEMAIL'                         => 'Send e-mails with inline Images',
    'SHOP_SYSTEM_LOGSKIPTAGS'                            => 'Exclusions for Admin log',
    'SHOP_SYSTEM_SMARTYPHPHANDLING'                      => 'How to handle PHP code embedded in templates',
    'SHOP_SYSTEM_SMARTYPHPHANDLING_REMOVE'               => 'Output code in HTML source (not displayed)',
    'SHOP_SYSTEM_SMARTYPHPHANDLING_PASSTHRU'             => 'Display code with PHP tags',
    'SHOP_SYSTEM_SMARTYPHPHANDLING_QUOTE'                => 'Display code without PHP tags',
    'SHOP_SYSTEM_SMARTYPHPHANDLING_ALLOW'                => 'Execute the PHP code',
    'SHOP_SYSTEM_LDAP'                                   => 'Activate LDAP authentification',
    'SHOP_SYSTEM_PLEASE_CHOOSE'                          => 'Please choose',

    'SHOP_SEO_SEOMODE'                        => 'Active',
    'SHOP_SEO_DEFSEOLANGUAGE'                 => 'Default language for SEO URLs',
    'SHOP_SEO_TITLEPREFIX'                    => 'Title Prefix',
    'SHOP_SEO_TITLESUFFIX'                    => 'Title Suffix',
    'SHOP_SEO_STARTTITLE'                     => 'Front Page Title',
    'SHOP_SEO_ROOTVENDORID'                   => 'Root vendor SEO ID',
    'SHOP_SEO_IDSSEPARATOR'                   => 'SEO IDs Separator (e.g. "+", "-")',
    'SHOP_SEO_SAFESEOPREF'                    => 'SEO Suffix for differing Similar SEO URLs',
    'SHOP_SEO_RESETIDS'                       => 'Update SEO URLs',
    'SHOP_SEO_QRESETIDS'                      => 'ATTENTION: This function will reset current SEO IDs for Categories, Products, Manufacturers and Distributors. The SEO IDs will be recalculated the next time the accordant page is opened.',
    'SHOP_SEO_NEWINSTALL'                     => 'ATTENTION: you need to make sure that the distributed .htaccess works correct (mod rewrite)',
    'SHOP_SEO_STATICURLS'                     => 'Static URLs',
    'SHOP_SEO_STDURL'                         => 'Standard URL',
    'SHOP_SEO_NEWSTATICURL'                   => '-- new --',
    'SHOP_SEO_RESERVEDWORDS'                  => 'Reserved Words (are automatically suffixed)',
    'SHOP_SEO_SKIPTAGS'                       => 'Words which are ignored in automatic Creation of Meta-tags.',
    'SHOP_SEO_LOWERCASEURLS'                  => 'Lowercase SEO urls',
    'SHOP_LICENSE_SERIAL'                     => 'Installed License Keys',
    'SHOP_LICENSE_NEWSERIAL'                  => 'Add License Keys',
    'SHOP_LICENSE_VERSION'                    => 'eShop Version',
    'SHOP_LICENSE_DEMO'                       => 'Demo-Version',
    'SHOP_LICENSE_COMMUNITY'                  => 'Community',
    'SHOP_LICENSE_PROFFESIONAL'               => 'Professional',
    'SHOP_LICENSE_ENTERPRISE'                 => 'Enterprise',
    'SHOP_LICENSE_ONLINECHECK'                => 'Check for current version',
    'SHOP_LICENSE_ALLOWEDMANDATES'            => 'max. Nr. of mandates',
    'SHOP_LICENSE_USEDMANDATES'               => 'Nr. of used mandates',
    'SHOP_LICENSE_MALL'                       => 'Mall mode',
    'SHOP_LICENSE_ERPINTERFACE'               => 'ERP Interface',
    'SHOP_LIST_MENUITEM'                      => 'Master Settings',
    'SHOP_LIST_MENUSUBITEM'                   => 'Core Settings',
    'SHOP_LIST_YOUWANTTODELETE'               => 'Do you really want to delete this shop?',
    'SHOWLIST_TITLE'                          => '[OXID List]',
    'SHOWLIST_SQL'                            => 'SQL',
    'SHOWLIST_CNT'                            => 'Cnt',
    'SHOWLIST_NORESULTS'                      => 'No entries found! No match or invalid search string!',
    'SHOWLIST_SUM'                            => 'Sum',
    'SYSTEMINFO_MENUITEM'                     => 'Service',
    'SYSTEMINFO_MENUSUBITEM'                  => 'System Info',
    'SYSTEMINFO_DEMOMODE'                     => 'DEMO MODE',
    'SYSTEMINFO_VARIABLE'                     => 'Variable',
    'SYSTEMINFO_VALUE'                        => 'Value',
    'SYSREQ_LIST_MENUITEM'                    => 'Service',
    'SYSREQ_LIST_MENUSUBITEM'                 => 'System health',
    'SYSREQ_PHP_EXTENNSIONS'                  => 'PHP extensions',
    'SYSREQ_PHP_CONFIG'                       => 'PHP configuration',
    'SYSREQ_SERVER_CONFIG'                    => 'Server configuration',
    'SYSREQ_SERVER_PERMISSIONS'               => 'Files/folders access rights',
    'SYSREQ_MOD_REWRITE'                      => 'Apache mod_rewrite module',
    'SYSREQ_ALLOW_URL_FOPEN'                  => 'allow_url_fopen or fsockopen to port 80',
    'SYSREQ_PHP4_COMPAT'                      => 'Zend compatibility mode must be off',
    'SYSREQ_PHP_VERSION'                      => 'PHP version 7.0 or 7.1',
    'SYSREQ_REQUEST_URI'                      => 'REQUEST_URI set',
    'SYSREQ_LIB_XML2'                         => 'LIB XML2',
    'SYSREQ_PHP_XML'                          => 'DOM',
    'SYSREQ_J_SON'                            => 'JSON',
    'SYSREQ_I_CONV'                           => 'ICONV',
    'SYSREQ_TOKENIZER'                        => 'Tokenizer',
    'SYSREQ_BC_MATH'                          => 'BCMath',
    'SYSREQ_MYSQL_CONNECT'                    => 'PDO_MySQL',
    'SYSREQ_MYSQL_VERSION'                    => 'MySQL version 5.5 or 5.7',
    'SYSREQ_GD_INFO'                          => 'GDlib v2 incl. JPEG support',
    'SYSREQ_INI_SET'                          => 'ini_set allowed',
    'SYSREQ_REGISTER_GLOBALS'                 => 'register_globals must be off',
    'SYSREQ_ZEND_OPTIMIZER'                   => 'Zend Guard Loader installed',
    'SYSREQ_ZEND_PLATFORM_OR_SERVER'          => 'Zend Platform or Zend Server installed',
    'SYSREQ_MB_STRING'                        => 'mbstring',
    'SYSREQ_CURL'                             => 'cURL',
    'SYSREQ_OPEN_SSL'                         => 'OpenSSL',
    'SYSREQ_SOAP'                             => 'SOAP',
    'SYSREQ_UNICODE_SUPPORT'                  => 'UTF-8 support',
    'SYSREQ_FILE_UPLOADS'                     => 'File uploads are enabled (file_uploads)',
    'SYSREQ_SESSION_AUTOSTART'                => 'session.auto_start must be off',
    'SYSREQ_BUG53632'                         => 'Possible issues on server due to PHP Bugs',
    'SYSREQ_MEMORY_LIMIT'                     => 'PHP Memory limit (min. 32MB, 60MB recommended)',
    'SYSREQ_DESCRIPTION_PASS'                 => 'System health is good.',
    'SYSREQ_DESCRIPTION_PMIN'                 => 'System health might be broken.',
    'SYSREQ_DESCRIPTION_FAIL'                 => 'System health is broken or security is compromised. This OXID eShop will not work properly in all cases and might behave strange.',
    'SYSREQ_DESCRIPTION_NULL'                 => 'System health is not able not be checked.',
    'SYSREQ_DESCRIPTION_COLL'                 => 'Collations in some columns do not match',
    'SYSREQ_DESCRIPTION_REQ'                  => 'State of system health',
    'SYSREQ_MODULE_BLOCKS_REQ'                => 'Missing module blocks in templates',
    'SYSREQ_MODULE_BLOCKS_MODNAME'            => 'Module name',
    'SYSREQ_MODULE_BLOCKS_BLOCKNAME'          => 'Block name',
    'SYSREQ_MODULE_BLOCKS_TPLFILE'            => 'Template file',
    'SYSREQ_MAGIC_QUOTES_GPC'                 => 'magic_quotes_gpc must be off',
    'TOOLS_LIST_TITLE'                        => '[OXID Tools]',
    'TOOLS_LIST_SECCESS'                      => 'Backup data mailed successfully.',
    'TOOLS_LIST_ACTIONEND'                    => 'Action completed',
    'TOOLS_LIST_SQLQUERY'                     => 'SQL query',
    'TOOLS_LIST_AFFECTEDROWS'                 => 'Affected rows',
    'TOOLS_LIST_ERRORMESSAGE'                 => 'Error message',
    'TOOLS_LIST_ERRORNUM'                     => 'Error number',
    'TOOLS_LIST_MENUITEM'                     => 'Service',
    'TOOLS_LIST_MENUSUBITEM'                  => 'Tools',
    'TOOLS_MAIN_TITLE'                        => '[OXID Tools]',
    'TOOLS_MAIN_UPDATESQL'                    => 'Update SQL',
    'TOOLS_MAIN_SQLDUMB'                      => 'Import SQL File<br>(large files should be uploaded via ftp)',
    'TOOLS_MAIN_START'                        => 'Start Update',
    'TOOLS_MAIN_CHECKPICS'                    => 'Search and delete unused Pictures',
    'TOOLS_MAIN_UPDATEVIEWSINFO'              => 'After particular DB table structure updates, in order changes to take effect you need to regenerate DB views.',
    'TOOLS_MAIN_UPDATEVIEWSNOW'               => 'Update DB Views now',
    'TOOLS_MAIN_UPDATEVIEWSCONFIRM'           => 'Are you sure you want to update views now?',
    'TOOLS_LIST_UPDATEVIEWSSECCESS'           => 'DB Views updated successfully.',
    'TOOLS_LIST_UPDATEVIEWSFAILED'            => 'DB Views update failed.',
    'TOOLTIPS_ADDSUMTYPE'                     => 'Absolute or<br>percentage<br>Surcharge/Reduction',
    'TOOLTIPS_ADDSUMITMTYPE'                  => 'Absolute, percentage<br> or Product<br>Markup/Discount',
    'TOOLTIPS_ARTICLEVAT'                     => 'Specify only if individual VAT',
    'TOOLTIPS_ARTICLEREVIEW'                  => 'Open Product Preview',
    'TOOLTIPS_ARTICLESTOCK'                   => 'Quantity Products in stock',
    'TOOLTIPS_ARTICLEDELIVERY'                => 'Time Format: ',
    'TOOLTIPS_ARTICLETEMPLATE'                => 'Template Filename<br>if not default',
    'TOOLTIPS_ARTICLEURLIMG'                  => 'Change of templates needed',
    'TOOLTIPS_ARTLIST_SEARCHFIELDOXDYNAMIC'   => 'search',
    'TOOLTIPS_ARTLIST_SEARCHFIELDOXTITLE'     => 'search Title',
    'TOOLTIPS_ARTLIST_SEARCHFIELDOXSHORTDESC' => 'search Short Description',
    'TOOLTIPS_ARTICLEUNITDESCRIPTION'         => 'Under the basic price is the price to understand, based<br> on a specific unit of measure applies, including<br> the sales tax and other price components.',
    'TOOLTIPS_EDITVAR'                        => 'Edit Variant',
    'TOOLTIPS_FORMAT'                         => 'Format : YYYY-MM-DD',
    'TOOLTIPS_ITEMDELETE'                     => 'Delete Entry',
    'TOOLTIPS_ITEMSTORNO'                     => 'Cancel Entry',
    'TOOLTIPS_NEWUSER'                        => 'Create new User',
    'TOOLTIPS_NEWADDRESS'                     => 'Create new Address',
    'TOOLTIPS_NEWUSERPAYMENT'                 => 'Create new Payment Method',
    'TOOLTIPS_NEWREMARK'                      => 'Add Note',
    'TOOLTIPS_NEWPAYMENT'                     => 'Create new Payment Method',
    'TOOLTIPS_NEWNEWSLETTER'                  => 'New Newsletter Sample',
    'TOOLTIPS_NEWSHOP'                        => 'Create New Shop',
    'TOOLTIPS_NEWUSERGROUP'                   => 'Create New User Group',
    'TOOLTIPS_NEWCATEGORY'                    => 'Create New Category',
    'TOOLTIPS_NEWCOUNTRY'                     => 'Create New Country',
    'TOOLTIPS_NEWLANGUAGE'                    => 'Create New Language',
    'TOOLTIPS_NEWWRAPPING'                    => 'Create New Wrapping',
    'TOOLTIPS_NEWCONTENT'                     => 'Create New Content',
    'TOOLTIPS_NEWMALLCAT'                     => 'Create New Mall Category',
    'TOOLTIPS_NEWARTICLE'                     => 'Create New Product',
    'TOOLTIPS_NEWITEMS'                       => 'Create new Attribute',
    'TOOLTIPS_NEWVAR1'                        => 'New',
    'TOOLTIPS_NEWVAR2'                        => 'below',
    'TOOLTIPS_NEWVAR3'                        => 'create Variant',
    'TOOLTIPS_NEWSELECTLIST'                  => 'Create new Selection List',
    'TOOLTIPS_NEWDISCOUNT'                    => 'Create new Discount',
    'TOOLTIPS_NEWMWST'                        => 'Create new VAT',
    'TOOLTIPS_NEWDELIVERY'                    => 'Create new Shipping Cost Rule',
    'TOOLTIPS_NEWDELIVERYSET'                 => 'Create new Shipping Method',
    'TOOLTIPS_NEWNEWS'                        => 'Create new Message',
    'TOOLTIPS_NEWVOUCHER'                     => 'Create new Coupon Serie',
    'TOOLTIPS_NEWCATTREE'                     => 'Re-Index Category Tree',
    'TOOLTIPS_NEWLINK'                        => 'Create new Link',
    'TOOLTIPS_NEWACTIONS'                     => 'Create new Action',
    'TOOLTIPS_NEWVENDOR'                      => 'Create new Distributor',
    'TOOLTIPS_NEWMANUFACTURER'                => 'Create new Manufacturer',
    'TOOLTIPS_OPENHELP'                       => 'Start Help',
    'TOOLTIPS_OPENUSERLIST'                   => 'Open User List',
    'TOOLTIPS_RECALCNROFARTICLESINCAT'        => 'Recalculate Number of Products in Categories',
    'TOOLTIPS_RECALCNROFARTICLESINVND'        => 'Recalculate Number of Products in Distributors',
    'TOOLTIPS_RECALCNROFARTICLESINMAN'        => 'Recalculate Number of Products in Manufacturers',
    'TOOLTIPS_RESETNROFARTICLESINCAT'         => 'Reset Number of Products in Categories',
    'TOOLTIPS_RESETNROFARTICLESINVND'         => 'Reset Number of Products in Distributors',
    'TOOLTIPS_RESETNROFARTICLESINMAN'         => 'Reset Number of Products in Manufacturers',
    'TOOLTIPS_TIMEFORMAT'                     => 'Time Format: ',
    'TOOLTIPS_VALDESC'                        => 'Entry1__@@Entry2__@@ usw.',
    'TOOLTIPS_ITEMUNASSIGN'                   => 'Unassign from shop',
    'TOOLTIPS_ARTLIST_NEWROLE'                => 'Create new Role',
    'TOOLTIPS_ARTLIST_ROLEGENERATOR'          => '(Re) Generate Rights & Roles fields',
    'USER_ADDRESS_DELIVERYADDRESS'            => 'Shipping Addresses',
    'USER_ARTICLE_QUANTITY'                   => 'Quantity',
    'USER_EXTEND_PRIVATFON'                   => 'Evening Phone',
    'USER_EXTEND_MOBILFON'                    => 'Celluar Phone',
    'USER_EXTEND_NEWSLETTER'                  => 'Recieves Newsletter',
    'USER_EXTEND_EMAILFAILED'                 => 'E-mail Adr. is Invalid',
    'USER_EXTEND_BONI'                        => 'Credit Rating',
    'USER_EXTEND_CREDITPOINTS'                => 'Credit points',
    'USER_LIST_ZIP'                           => 'ZIP',
    'USER_LIST_PLACE'                         => 'City',
    'USER_LIST_CUSTOMERNUM'                   => 'Cust No.',
    'CUSTOMERNUM'                             => 'Cust No.',
    'USER_LIST_MENNUITEM'                     => 'Administer Users',
    'USER_LIST_MENNUSUBITEM'                  => 'Users',
    'USER_MAIN_RIGHTS'                        => 'Rights',
    'USER_MAIN_EMAILLOGIN'                    => 'E-mail/Login',
    'USER_MAIN_CUSTOMERSNR'                   => 'Customer No.',
    'USER_MAIN_HASPASSWORD'                   => 'Has password?',
    'USER_MAIN_NAME'                          => 'Name, Surname',
    'USER_MAIN_STRNR'                         => 'Street, Street No.',
    'USER_MAIN_NEWPASSWORD'                   => 'New Password',
    'USER_MAIN_LDAP'                          => 'LDAP user',
    'USER_OVERVIEW_GROUPS'                    => 'User Groups',
    'USER_OVERVIEW_LASTITEM'                  => 'Last purchased Products',
    'USER_OVERVIEW_LASTBUY'                   => 'Last Purchase',
    'USER_OVERVIEW_BONI'                      => "'Traffic Light' Credit Rating",
    'USER_OVERVIEW_OXID'                      => 'OXID',
    'USER_OVERVIEW_BREACKORDER'               => 'Aborted Orders',
    'USER_PAYMENT_PAYMENT'                    => 'Payment Methods',
    'USER_PAYMENT_NEWPAYMENT'                 => 'New Payment Methods',
    'USER_PAYMENT_PAYMENTTYPE'                => 'Method Type',
    'USER_PAYMENT_VALUE'                      => 'Value',
    'USER_REMARK_REMARK'                      => '[Remark]',
    'USER_REMARK_ORDER'                       => '[Order]',
    'USER_REMARK_USER'                        => '[Reg.]',
    // @deprecated since v.5.3.0 (2016-06-17); The Admin Menu: Customer Info -> News feature will be moved to a module in v6.0.0
    'USER_REMARK_NEWS'                        => '[News]',
    // END deprecated
    'USERGROUP_LIST_MENUITEM'                 => 'Administer Users',
    'USERGROUP_LIST_MENUSUBITEM'              => 'User Groups',
    'USERGROUP_MAIN_MEMBERINGROUP'            => 'User Group Members',
    'USERGROUP_MAIN_ALLMEMBERS'               => 'All Users',
    'VENDOR_LIST_MENUITEM'                    => 'Master Settings',
    'VENDOR_LIST_MENUSUBITEM'                 => 'Distributors',
    'VENDOR_LIST_TITLE'                       => '[OXID Vendor Administration]',
    'VENDOR_MAIN_ALLITEMS'                    => 'All available Products',
    'VENDOR_MAIN_ITEMSWITHVENDOR'             => 'Products from this Distributor',
    'VENDOR_MAIN_ICONUPLOAD'                  => 'Upload Icon',
    'VOUCHERSERIE_GROUPS_INGROUP'             => 'Available for User Groups',
    'VOUCHERSERIE_LIST_SERIALNUM'             => 'Name',
    'VOUCHERSERIE_LIST_MINVALUE'              => 'Min. Order Sum',
    'VOUCHERSERIE_LIST_MENUITEM'              => 'Shop Settings',
    'VOUCHERSERIE_LIST_MENUSUBITEM'           => 'Coupon Series',
    'VOUCHERSERIE_MAIN_GENERATERANDOM'        => 'Generate Random No',
    'VOUCHERSERIE_MAIN_MINORDERPRICE'         => 'Min. Order Sum',
    'VOUCHERSERIE_MAIN_ALLOWSAMESERIES'       => 'Valid with same Series',
    'VOUCHERSERIE_MAIN_ALLOWOTHERSERIES'      => 'Valid with different Series',
    'VOUCHERSERIE_MAIN_SAMESEROTHERORDER'     => 'Valid with same Series, different Order',
    'VOUCHERSERIE_MAIN_NEWVOUCHER'            => 'Create new Coupons',
    'VOUCHERSERIE_MAIN_VOUCHERSTATISTICS'     => 'Coupons',
    'VOUCHERSERIE_MAIN_RANDOMNUM'             => 'Random Numbers',
    'VOUCHERSERIE_MAIN_VOUCHERNUM'            => 'Coupon Number',
    'VOUCHERSERIE_MAIN_AVAILABLE'             => 'Available',
    'VOUCHERSERIE_MAIN_USED'                  => 'Used',
    'VOUCHERSERIE_MAIN_DISCOUNT'              => 'Discount',
    'VOUCHERSERIE_MAIN_CALCULATEONCE'         => 'Calculate only once (valid only for product or category vouchers)',

    'VOUCHERSERIE_MAIN_GENERATE'  => 'Generate',
    'VOUCHERSERIE_MAIN_EXPORT'    => 'Export',
    'VOUCHERSERIE_GENERATING'     => 'Generating coupons ...',
    'VOUCHERSERIE_GENERATED'      => 'Coupons generated: ',
    'VOUCHERSERIE_GENERATEDONE'   => 'Coupons generation completed.',
    'VOUCHERSERIE_EXPORTING'      => 'Exporting coupons ...',
    'VOUCHERSERIE_EXPORTED'       => 'Coupons exported: ',
    'VOUCHERSERIE_EXPORTDONE'     => 'Coupons export completed.',
    'VOUCHERSERIE_EXPORTDOWNLOAD' => 'Download',

    'WRAPPING_LIST_PICTURE'                   => 'Picture',
    'WRAPPING_LIST_PRESENTPACKUNG'            => 'Gift Wrapping',
    'WRAPPING_LIST_MENUITEM'                  => 'Shop Settings',
    'WRAPPING_LIST_MENUSUBITEM'               => 'Gift Wrapping',
    'WRAPPING_LIST_TITLE'                     => '[OXID Wrapping]',
    'WRAPPING_MAIN_PICTURE'                   => 'Picture',
    'WRAPPING_MAIN_PRESENTPACKUNG'            => 'Gift Wrapping',
    'WRAPPING_MAIN_PICUPLOAD'                 => 'Upload Picture',
    'WRAPPING_MAIN_TITLE'                     => '[OXID Wrapping]',
    'SHOP_PERF_CALCVATONLYFORBASKETORDER'     => 'Calculate specific VAT for countries only in Shopping Cart and Checkout',
    'MANUFACTURER_MAIN_ICONUPLOAD'            => 'Upload Icon',
    'MANUFACTURER_MAIN_ITEMSWITHMANUFACTURER' => 'Products from this Manufacturer',
    'MANUFACTURER_MAIN_ALLITEMS'              => 'All Products',
    'MANUFACTURER_LIST_TITLE'                 => 'Manufacturer List',
    'MANUFACTURER_LIST_MENUITEM'              => 'Master Settings',
    'MANUFACTURER_LIST_MENUSUBITEM'           => 'Brands/Manufacturers',
    'SHOP_PERF_CHECKIFTPLCOMPILE'             => 'Automatic detection of necessary Template re-compilation. Uncheck during normal operation for increased performance.',
    'SHOP_PERF_COMPARE'                       => 'Activate Product Comparison',
    'SHOP_PERF_DONTSHOWEMTYCATEGORIES'        => 'Do <strong>not</strong> display empty Categories (Categories which have no Sub-Categories and no Products).',
    'SHOP_PERF_CLEARCACHEONLOGOUT'            => 'Delete cache <b>only</b> on logout from admin.',
    'SHOP_PERF_EXTERNALPERFORMANCE'           => 'Enhanced Performance Settings',
    'SHOP_PERF_LOADTREEFORSEARCH'             => 'Load complete Category Tree for Search',
    'SHOP_PERF_LOADFULLTREE'                  => 'Load complete Category Tree for Navigation (May cause Performance Problems if much Categories exist)',
    'SHOP_PERF_LOADACTION'                    => 'Load Promotions',
    'SHOP_PERF_LOADCROSSSELLING'              => 'Load Crossselling',
    'SHOP_PERF_LOADACCESSOIRES'               => 'Load Accessories',
    'SHOP_PERF_LOADCUSTOMERWHOBOUGHTTHIS'     => 'Load "Customers who bought this product also purchased ..."',
    'SHOP_PERF_LOADSIMILAR'                   => 'Load similar Products',
    'SHOP_PERF_LOADSELECTLIST'                => 'Load Selection Lists',
    'SHOP_PERF_LOADSELECTLISTSINALIST'        => 'Load Selection Lists in Product Lists',
    'SHOP_PERF_LOADDISCOUNTS'                 => 'Calculate Discounts and VAT',
    'SHOP_PERF_LOADDELIVERY'                  => 'Calculate Shipping Costs',
    'SHOP_PERF_LOADPRICE'                     => 'Calculate Product Price',
    'SHOP_PERF_LOADPRICEFORADDLIST'           => 'Show Prices in "Top of the Shop" and "Just arrived!"',
    'SHOP_PERF_LOADCATTREE'                   => 'Load Categories and display Category Navigation',
    'SHOP_PERF_LOADCURRENCY'                  => 'Display Currencies',
    'SHOP_PERF_LOADLANGUAGES'                 => 'Display Languages',
    'SHOP_PERF_LOADNEWS'                      => 'Load News',
    // @deprecated since v.5.3.0 (2016-06-17); The Admin Menu: Customer Info -> News feature will be moved to a module in v6.0.0
    'SHOP_PERF_LOADNEWSONLYSTART'             => 'Load News only on Start Page',
    // END deprecated
    'SHOP_PERF_LOADVARIANTS'                  => 'Load Variants in Lists (Search Results, Categories). This uses much Memory and may cause Performance Problems on small Servers',
    'SHOP_PERF_LOADMANUFACTURERTREE'          => 'Load and display Manufacturer List',
    'SHOP_PERF_NEWESTARTICLES'                => 'List of newest Products (Just arrived!)',
    'SHOP_PERF_PARSELONGDESCINSMARTY'         => 'Process Description of Articles and Categories with Smarty',
    'SHOP_PERF_PERFORMANCE'                   => 'Performance',
    'SHOP_PERF_SHOWACTCATARTCOUNT'            => 'Display Number of contained Products behind Category Names',
    'SHOP_PERF_TOPSELLER'                     => 'List of most sold Products (Top of the Shop)',
    'SHOP_PERF_USESELECTLISTPRICE'            => 'Support Price Modifications by Selection Lists',
    'SHOP_PERF_USETIMECHECKINARTLOAD'         => 'Check "Active From/To" when loading Products',
    'SHOP_PERF_DISBASKETSAVING'               => 'Don\'t save Shopping Carts of registered Users',
    'SHOP_PERF_HIDELEFTCOLUMN'                => 'Hide left column',
    'DYNSCREEN_LOCAL_TITLE'                   => 'e-commerce Services',
    'DYNSCREEN_LOCAL_TEXT'                    => 'Some general info about e-commerce services ...',
    'GENIMPORT_MENUITEM'                      => 'Service',
    'GENIMPORT_MENUSUBITEM'                   => 'Generic Import',
    'GENIMPORT_STEP_1_TITLE'                  => 'Uploading CSV file',
    'GENIMPORT_STEP_2_TITLE'                  => 'Assigning CSV file fields',
    'GENIMPORT_STEP_3_TITLE'                  => 'Finishing import',
    'GENIMPORT_TABLE'                         => 'Table',
    'GENIMPORT_CSVFILE'                       => 'CSV file',
    'GENIMPORT_DBFIELDS'                      => 'DB fields',
    'GENIMPORT_FIRSTCOLHEADER'                => 'First column contains headers',
    'GENIMPORT_UPLOADFILE'                    => 'Upload file',
    'GENIMPORT_ERRORUPLOADINGFILE'            => 'Please select csv file',
    'GENIMPORT_ERRORASSIGNINGFIELDS'          => 'Please assign CSV file columns',
    'GENIMPORT_ASSIGNFIELDS'                  => 'Assigning CSV file fields to table',
    'GENIMPORT_REPEATIMPORT'                  => 'Repeat import',
    'GENIMPORT_REPEATINGIMPORT'               => 'Repeating import',
    'GENIMPORT_BEGINIMPORT'                   => 'Begin import',
    'GENIMPORT_IMPORTDONE'                    => 'CSV data was successfully imported.',
    'GENIMPORT_IMPORTDONEWITHERRORS'          => 'CSV data was not successfully imported. Some errors occured during import.',
    'GENIMPORT_TOTALROWS'                     => 'Total rows imported',
    'GENIMPORT_STEP'                          => 'Step',
    'GENIMPORT_FINISH'                        => 'Finish',
    'GENIMPORT_SKIP'                          => 'SKIP',
    'GENIMPORT_FIELDSTERMINATEDBY'            => 'Fields terminated by',
    'GENIMPORT_FIELDSENCLOSEDBY'              => 'Fields enclosed by',

    'GENEXPORT_MENUITEM'       => 'Service',
    'GENEXPORT_MENUSUBITEM'    => 'Product Export',

    /* menu */
    'dyn_menu'                 => 'Servicearea',
    'dyn_about'                => 'General',
    'dyn_interface'            => 'Interface',
    'dyn_technics'             => 'Technique',
    'mxactions'                => 'Promotions',
    'mxarticles'               => 'Products',
    'mxattributes'             => 'Attributes',
    'mxcategories'             => 'Categories',
    'mxcontent'                => 'CMS Pages',
    'mxcustnews'               => 'Customer Info',
    'mxcoresett'               => 'Core Settings',
    'mxcountries'              => 'Countries',
    'mxdiscount'               => 'Discounts',
    'mxdisplayorders'          => 'Orders',
    'mxgenexp'                 => 'Product Export',
    'mxgenimp'                 => 'Generic Import',
    'mxlanguages'              => 'Languages',
    'mxlist'                   => 'List All Users',
    'mxmanageprod'             => 'Administer Products',
    'mxmainmenu'               => 'Master Settings',
    'mxnews'                   => 'News',
    'mxorders'                 => 'Administer Orders',
    'mxpaymeth'                => 'Payment Methods',
    'mxpricealarm'             => 'Price Alert',
    'mxremlist'                => 'List All Reviews',
    'mxsellist'                => 'Selection Lists',
    'mxservice'                => 'Service',
    'mxservicearea'            => 'e-commerce Services',
    'mxshipping'               => 'Shipping Cost Rules',
    'mxshippingset'            => 'Shipping Methods',
    'mxshopsett'               => 'Shop Settings',
    'mxsysinfo'                => 'System Info',
    'mxsysreq'                 => 'System health',
    'mxtools'                  => 'Tools',
    'mxtheme'                  => 'Themes',
    'mxmodule'                 => 'Modules',
    'mxextensions'             => 'Extensions',
    'mxuadmin'                 => 'Administer Users',
    'mxurls'                   => 'Links',
    'mxugroups'                => 'User Groups',
    'mxusers'                  => 'Users',
    'mxvendor'                 => 'Distributors',
    'mxmanufacturer'           => 'Brands/Manufacturers',
    'mxvouchers'               => 'Coupon Series',
    'mxwrapping'               => 'Gift Wrapping',
    'mxdynscreenlocal'         => 'Services info',
    'mxoxexchange'             => 'OXID eXchange',
    'mxnewsletter'             => 'Newsletter',
    'mxorderovw'               => 'Order Summary',
    'mxpacklist'               => 'Packing List',
    'mxerp'                    => 'ERP interface',
    'mxberoles'                => 'Admin Roles',
    'mxferoles'                => 'Shop Roles',
    /* tabs */
    'tbclorder_iPayment'       => 'IPayment',
    // newsletter_list',
    'tbclnewsletter_main'      => 'HTML',
    'tbclnewsletter_plain'     => 'TEXT',
    'tbclnewsletter_preview'   => 'Preview',
    'tbclnewsletter_selection' => 'Selection',
    'tbcl_main'                => 'Main',
    'tbcladminlinks_mall'      => 'Mall',
    'tbcldelivery_mall'        => 'Mall',
    'tbcldeliveryset_mall'     => 'Mall',
    'tbcldiscount_mall'        => 'Mall',
    'tbclmanufacturer_mall'    => 'Mall',
    'tbclnews_mall'            => 'Mall',
    'tbclvendor_mall'          => 'Mall',
    'tbclselectlist_mall'      => 'Mall',
    'tbclvoucherserie_mall'    => 'Mall',
    'tbclwrapping_mall'        => 'Mall',
    'tbclattribute_mall'       => 'Mall',
    'tbclarticle_mall'         => 'Mall',
    'tbclcategory_mall'        => 'Mall',
    'tbclcategory_rights'      => 'Rights',
    'tbclshop_cache'           => 'Caching',
    'tbclshop_mall'            => 'Mall',
    'tbclroles_femain'         => 'Main',
    'tbclroles_feuser'         => 'Users',
    'tbclroles_bemain'         => 'Main',
    'tbclroles_beobject'       => 'Objects',
    'tbclroles_beuser'         => 'Users',
    'tbclarticle_rights'       => 'Rights',
    //  actions',
    'tbclactions_main'         => 'Main',
    //  attribute_list',
    'tbclattribute_main'       => 'Main',
    'tbclattribute_category'   => 'Category',
    //  article_list',
    'tbclarticle_main'         => 'Main',
    'tbclarticle_extend'       => 'Extended',
    'tbclarticle_stock'        => 'Stock',
    'tbclarticle_attribute'    => 'Selection',
    'tbclarticle_crossselling' => 'Crosssell.',
    'tbclarticle_variant'      => 'Variants',
    'tbclarticle_pictures'     => 'Pictures',
    'tbclarticle_files'        => 'Downloads',
    'tbclarticle_review'       => 'Review',
    'tbclarticle_overview'     => 'Statistics',
    // adminlinks_list',
    'tbcladminlinks_main'      => 'Main',
    //  content_list',
    'tbclcontent_main'         => 'Main',
    //  category_list',
    'tbclcategory_main'        => 'Main',
    'tbclcategory_text'        => 'Text',
    'tbclcategory_pictures'    => 'Picture',
    'tbclcategory_order'       => 'Sorting',
    //  Countries',
    'tbclcountry_main'         => 'Main',
    //  delivery_list',
    'tbcldelivery_main'        => 'Main',
    'tbcldelivery_articles'    => 'Products',
    'tbcldelivery_users'       => 'Users',
    //  deliveryset_list',
    'tbcldeliveryset_main'     => 'Main',
    'tbcldeliveryset_payment'  => 'Payment',
    'tbcldeliveryset_users'    => 'Users',
    'tbcldeliveryset_rdfa'     => 'RDFa',
    //  discount_list',
    'tbcldiscount_main'        => 'Main',
    'tbcldiscount_articles'    => 'Products',
    'tbcldiscount_users'       => 'Users',
    //languages
    'tbcllanguage_main'        => 'Main',
    //  news_list',
    'tbclnews_main'            => 'Main',
    'tbclnews_text'            => 'Text',
    //  order_list',
    'tbclorder_overview'       => 'Overview',
    'tbclorder_main'           => 'Main',
    'tbclorder_address'        => 'Addresses',
    'tbclorder_article'        => 'Products',
    'tbclorder_remark'         => 'History',
    'tbclorder_downloads'      => 'Downloads',
    //  payment_list',
    'tbclpayment_main'         => 'Main',
    'tbclpayment_country'      => 'Country',
    'tbclpayment_rdfa'         => 'RDFa',
    //  Pricealarm',
    'tbclpricealarm_main'      => 'Main',
    'tbclpricealarm_mail'      => 'Mail',
    //  selectlist_list',
    'tbclselectlist_main'      => 'Main',
    //  system requirements',
    'tbclsysreq_main'          => 'Main',
    //  shop_list',
    'tbclshop_main'            => 'Main',
    'tbclshop_config'          => 'Settings',
    'tbclshop_system'          => 'System',
    'tbclshop_license'         => 'License',
    'tbclshop_performance'     => 'Perform.',
    'tbclshop_seo'             => 'SEO',
    'tbclshop_rdfa'            => 'RDFa',
    //  Service Tools',
    'tbcltools_main'           => 'SQL',
    //  Theme,
    'tbcltheme_main'           => 'Overview',
    'tbcltheme_config'         => 'Settings',
    //  Module,
    'tbclmodule_main'          => 'Overview',
    'tbclmodule_config'        => 'Settings',
    'tbclmodule_sortlist'      => 'Installed Shop Modules',
    //  user_list',
    'tbcluser_main'            => 'Main',
    'tbcluser_extend'          => 'Extended',
    'tbcluser_article'         => 'Products',
    'tbcluser_remark'          => 'History',
    'tbcluser_address'         => 'Addresses',
    'tbcluser_payment'         => 'Payment',
    //  usergroup_list',
    'tbclusergroup_main'       => 'Main',
    //  vendor_list',
    'tbclvendor_main'          => 'Main',
    'tbclmanufacturer_main'    => 'Main',
    //  voucherserie_list',
    'tbclvoucherserie_main'    => 'Main',
    'tbclvoucherserie_groups'  => 'User Groups & Products',
    'tbclwrapping_main'        => 'Main',
    'tbclvendor_seo'           => 'SEO',
    'tbclmanufacturer_seo'     => 'SEO',
    'tbclcategory_seo'         => 'SEO',
    'tbclarticle_seo'          => 'SEO',
    'tbclcontent_seo'          => 'SEO',

    // userlist',
    'snpuserlistheader'        => 'List All Users',
    'snpuserlistoxfname'       => 'First Name',
    'snpuserlistoxlname'       => 'Last Name',
    'snpuserlistoxusername'    => 'E-mail',
    'snpuserlistoxcreate'      => 'Registered',
    // reviewlist',
    'snpreviewlistheader'      => 'List All Reviews',
    'snpreviewlistoxcreate'    => 'Created',
    'snpreviewlistoxtext'      => 'Content',
    'snpreviewlistoxtitle'     => 'Product',

    'mainCategory'                                => 'Maincat.',
    'none'                                        => 'none',
    'viewAll'                                     => 'Show all',
    'order'                                       => 'Order',
    'amount'                                      => 'Amount',
    'size'                                        => 'Size',
    'weight'                                      => 'Weight',
    'price'                                       => 'Price',
    'user'                                        => 'Customer',
    'mallAdmin'                                   => 'Mall Admin',
    'usrRegistered'                               => 'The user will be registered after entering his password.',
    // HTML editor',
    'editor_language'                             => 'en-us',
    //serials
    'invalid_serial'                              => 'Invalid license key',
    'nonstackable_serial_detected'                => 'Can\'t add non stackable license key. Please insert stackable license key first.',
    'serial_added'                                => 'License key has beend added',
    'serial_updated'                              => 'License key has been updated',

    // Shop licensing problems
    'SHOP_LICENSE_ERROR_GRACE_EXPIRED'            => 'The license key of your OXID eShop finally expired. Please contact the Technical Support.',
    'SHOP_LICENSE_ERROR_GRACE_WILL_EXPIRE'        => 'The license key of your OXID eShop is expired. OXID eShop will go offline within 24 hours. Please enter a valid license key or contact the Technical Support!',
    'SHOP_LICENSE_ERROR_GRACE_RESET'              => 'A re-check resulted that the license key of your OXID eShop is now valid. That\'s why the hidden countdown of seven days was cancelled .',
    'SHOP_LICENSE_ERROR_shop_unlicensed'          => 'A problem with the license key of your OXID eShop occurred. That\'s why a hidden countdown of 7 days was started. After this period OXID eShop will go offline. Please enter the valid license key once again or contact the technical support!',
    'SHOP_LICENSE_ERROR_serial_expired'           => 'The license key of your OXID eShop expired. That\'s why a hidden countdown of 7 days was started. After this period OXID eShop will go offline. Please enter a valid license key or contact the technical support!',
    'SHOP_LICENSE_ERROR_incorrect_mandate_amount' => 'The number of the licensed sub-shops exceeded. That\'s why a hidden countdown of 7 days was started. After this period OXID eShop will go offline. Please enter a valid license key or contact the technical support!',
    'SHOP_LICENSE_ERROR_INFORMATION'              => 'OXID eShop license information',

    'SHOP_EMAIL_ORIGIN_MESSAGE'                   => 'This e-mail was sent from shop %s.',

    'SHOP_OPTIONS_GROUP_GLOBAL'                    => 'Global',
    'SHOP_OPTIONS_GROUP_SEARCH'                    => 'Search',
    'SHOP_OPTIONS_GROUP_STOCK'                     => 'Stock',
    'SHOP_OPTIONS_GROUP_ARTICLES'                  => 'Products',
    'SHOP_OPTIONS_GROUP_ORDER'                     => 'Order',
    'SHOP_OPTIONS_GROUP_VAT'                       => 'VAT',
    'SHOP_OPTIONS_GROUP_LANGUAGE'                  => 'Language',
    'SHOP_OPTIONS_GROUP_PICTURES'                  => 'Pictures',
    'SHOP_OPTIONS_GROUP_SHOP_FRONTEND'             => 'Shop frontend',
    'SHOP_OPTIONS_GROUP_ADMINISTRATION'            => 'Administration',
    'SHOP_OPTIONS_GROUP_OTHER_SETTINGS'            => 'Other settings',
    'SHOP_OPTIONS_GROUP_VARIANTS'                  => 'Variants',
    'SHOP_OPTIONS_GROUP_PRIVATESALES'              => 'Private Sales',
    'SHOP_OPTIONS_GROUP_INVITATIONS'               => 'Invitations',
    'SHOP_OPTIONS_GROUP_SHOP_DOWNLOADABLEARTICLES' => 'Downloadable products',
    'SHOP_OPTIONS_BANK_INFORMATION'                => 'Bank account information (SEPA)',
    'SHOP_OPTIONS_GROUP_ACCOUNT_SETTINGS'          => 'Account settings',

    'PROMOTION_USERS_SETGROUPS'   => 'Assigned User Groups',
    'PROMOTION_LIST_ALL'          => 'All',
    'PROMOTION_LIST_ACTIVE'       => 'Active',
    'PROMOTION_LIST_UPCOMING'     => 'Upcoming',
    'PROMOTION_LIST_EXPIRED'      => 'Expired',
    'PROMOTION_LIST_STARTTIME'    => 'Start Time',
    'PROMOTIONS_MAIN_TYPE_ACTION' => 'Action',
    'PROMOTIONS_MAIN_TYPE_PROMO'  => 'Promotion',
    'PROMOTIONS_MAIN_TYPE_BANNER' => 'Banner',
    'TOOLTIPS_NEWPROMOTION'       => 'New Action/Promotion/Banner',

    'PROMOTIONS_BANNER_LINK'             => 'Banner link',
    'PROMOTIONS_BANNER_PICTUREANDLINK'   => 'Banner picture and link',
    'PROMOTIONS_BANNER_PICTUREUPLOAD'    => 'Choose picture',
    'PROMOTIONS_BANNER_ASSIGNEDARTICLE'  => 'Assigned product',
    'PROMOTIONS_ARTICLE_ASSIGNARTICLE'   => 'Assign Product',
    'PROMOTIONS_ARTICLE_UNASSIGNARTICLE' => 'Unassign Product',
    'PROMOTIONS_ARTICLE_ASSIGNEDARTICLE' => 'Assigned Product',
    'PROMOTIONS_ARTICLE_ALLITEMS'        => 'All available Products',

    'SHOP_RDFA_TECH_CONFIG'           => 'Global configuration',
    'SHOP_RDFA_EMBEDDING'             => 'Enable automatic data embedding',
    'SHOP_RDFA_CONTENT_OFFERER'       => 'In which content page the RDF data of the <b>eShop</b> shall be embedded?',
    'SHOP_RDFA_ASSIGN_PAYMENT'        => 'To assign your payment methods to RDFa payment methods go to: Shop Settings -> Payment Methods -> RDFa.',
    'SHOP_RDFA_ASSIGN_DELIVERY'       => 'To assign your shipping methods to RDFa shipping methods go to: Shop Settings -> Shipping Methods -> RDFa.',
    'SHOP_RDFA_CONTENT_PAYMENT'       => 'In which content page the RDF data of not assigned <b>payment methods</b> shall be embedded?',
    'SHOP_RDFA_CONTENT_DELIVERY'      => 'In which content page the RDF data of not assigned <b>shipping methods</b> shall be embedded?',
    'SHOP_RDFA_RATING_MIN'            => 'How many stars can purchasers assign to a product <b>minimum</b>?',
    'SHOP_RDFA_RATING_MAX'            => 'How many stars can purchasers assign to a product <b>maximum</b>?',
    'SHOP_RDFA_DATA_OFFERER'          => 'Shop information',
    'SHOP_RDFA_DATA_MASTER'           => 'Main shop data',
    'SHOP_RDFA_DATA_EXTENDED'         => 'Extended shop data',
    'SHOP_RDFA_LOGO_URL'              => 'URL of the logo',
    'SHOP_RDFA_GEO_LONGITUDE'         => 'Geo-position: Longitude',
    'SHOP_RDFA_GEO_LATITUDE'          => 'Geo-position: Latitude',
    'SHOP_RDFA_GLN'                   => 'GLN',
    'SHOP_RDFA_NAICS'                 => 'NAICS',
    'SHOP_RDFA_ISIC'                  => 'ISIC',
    'SHOP_RDFA_DUNS'                  => 'D-U-N-S',
    'SHOP_RDFA_GLOBAL_OFFERING_DATA'  => 'Special product information',
    'SHOP_RDFA_VAT'                   => 'Are the prices and costs shown to the purchaser <b>incl.</b> or <b>excl. VAT</b>?',
    'SHOP_RDFA_VAT_INC'               => 'incl. VAT.',
    'SHOP_RDFA_VAT_EX'                => 'excl. VAT.',
    'SHOP_RDFA_COND'                  => 'In which <b>condition</b> are the offered product items?',
    'SHOP_RDFA_COND_NEW'              => 'new',
    'SHOP_RDFA_COND_USED'             => 'used',
    'SHOP_RDFA_COND_REFURBISHED'      => 'refurbished',
    'SHOP_RDFA_FNC'                   => 'Which <b>function</b> do your offers have?',
    'SHOP_RDFA_FNC_SELL'              => 'Sell',
    'SHOP_RDFA_FNC_LEASEOUT'          => 'Lease out',
    'SHOP_RDFA_FNC_REPAIR'            => 'Repair',
    'SHOP_RDFA_FNC_MAINTAIN'          => 'Maintain',
    'SHOP_RDFA_FNC_CONSTINST'         => 'Construction/Installation',
    'SHOP_RDFA_FNC_SERVICE'           => 'Provide service',
    'SHOP_RDFA_FNC_DISPOSE'           => 'Dispose',
    'SHOP_RDFA_FNC_NONE'              => 'None of the shown',
    'SHOP_RDFA_COSTUMER'              => 'Which <b>customer group</b> is addressed by your offers?',
    'SHOP_RDFA_COSTUMER_ENDUSER'      => 'End user',
    'SHOP_RDFA_COSTUMER_RESELLER'     => 'Reseller',
    'SHOP_RDFA_COSTUMER_BUSINESS'     => 'Business',
    'SHOP_RDFA_COSTUMER_PUBLIC'       => 'Public',
    'SHOP_RDFA_DURATION_OFFERINGS'    => 'Select the time of the validity of your products.',
    'SHOP_RDFA_DURATION_PRICES'       => 'Select the time of the validity of your prices and costs.',
    'SHOP_RDFA_1_DAY'                 => '1 day',
    'SHOP_RDFA_3_DAYS'                => '3 days',
    'SHOP_RDFA_7_DAYS'                => '7 days (1 week)',
    'SHOP_RDFA_14_DAYS'               => '14 days (2 weeks)',
    'SHOP_RDFA_30_DAYS'               => '30 days (1 month)',
    'SHOP_RDFA_178_DAYS'              => '178 days (6 months)',
    'SHOP_RDFA_356_DAYS'              => '356 days (1 year)',
    'SHOP_RDFA_URL'                   => 'Shop URL',
    'SHOP_RDFA_EMAIL'                 => 'Contact (e-mail)',
    'SHOP_RDFA_SUBMITED_SUCCESSFULLY' => 'Your shop data were successfully submitted',
    'SHOP_RDFA_MESSAGE_NOURL'         => 'Please add shop URL',
    'SHOP_RDFA_SUBMIT'                => 'Submit',
    'SHOP_RDFA_SHOW_PRODUCTSTOCK'     => 'Show real available product stock',

    'PAYMENT_RDFA_ASIGN_PAYMENT'           => 'Assign payment',
    'PAYMENT_RDFA_ADVICE'                  => '<b>Hint:</b> Please choose only those payment methods, pre-defined in GoodRelations, that comply with your payment method <b>%s</b>.',
    'PAYMENT_RDFA_GENERAL'                 => 'General payment methods',
    'PAYMENT_RDFA_CASH'                    => 'Cash',
    'PAYMENT_RDFA_GOOGLECHECKOUT'          => 'Google Checkout',
    'PAYMENT_RDFA_DIRECTDEBIT'             => 'Direct debit',
    'PAYMENT_RDFA_COD'                     => 'Cash on delivery',
    'PAYMENT_RDFA_PAYPAL'                  => 'PayPal',
    'PAYMENT_RDFA_PAYSWARM'                => 'PaySwarm',
    'PAYMENT_RDFA_BYINVOICE'               => 'Invoice',
    'PAYMENT_RDFA_CHECKINADVANCE'          => 'Check in advance',
    'PAYMENT_RDFA_BYBANKTRANSFERINADVANCE' => 'Cash in advance',
    'PAYMENT_RDFA_CREDITCARD'              => 'Credit card payment',
    'PAYMENT_RDFA_AMERICANEXPRESS'         => 'American Express',
    'PAYMENT_RDFA_DINERSCLUB'              => 'Diners Club',
    'PAYMENT_RDFA_DISCOVER'                => 'Discover',
    'PAYMENT_RDFA_JCB'                     => 'JCB',
    'PAYMENT_RDFA_MASTERCARD'              => 'MasterCard',
    'PAYMENT_RDFA_VISA'                    => 'VISA',

    'DELIVERY_RDFA_ASIGN_DELIVERY'             => 'Assign delivery method',
    'DELIVERY_RDFA_ADVICE'                     => '<b>Hint:</b> Please choose only those delivery methods, pre-defined in GoodRelations, that comply with your shipping method',
    'DELIVERY_RDFA_GENERAL'                    => 'General delivery methods',
    'DELIVERY_RDFA_DELIVERYMODEDIRECTDOWNLOAD' => 'Download',
    'DELIVERY_RDFA_DELIVERYMODEOWNFLEET'       => 'Own fleet',
    'DELIVERY_RDFA_DELIVERYMODEMAIL'           => 'Snail Mail',
    'DELIVERY_RDFA_DELIVERYMODEPICKUP'         => 'Pick up',
    'DELIVERY_RDFA_DELIVERYMODEFREIGHT'        => 'Freight',
    'DELIVERY_RDFA_PARCELSERVICE'              => 'Parcel Services',
    'DELIVERY_RDFA_DHL'                        => 'DHL',
    'DELIVERY_RDFA_FEDERALEXPRESS'             => 'FedEx',
    'DELIVERY_RDFA_UPS'                        => 'UPS',
    'SHOP_SYSTEM_SHOWREMEMBERME'               => 'Show "Remember me" option in login box',
    'NEWSLETTER_SUBJECT'                       => 'Subject',

    'SHOP_PERF_SEO_CACHE'                        => 'Enable SEO cache',
    'SHOP_PERF_SYSREQ_CHECK'                     => 'Enable system health messages at the start page',
    'INFO_MODULES_MOVED_TO_EXTENSIONS'           => 'Themes and modules handling moved to new menu "Extensions"',
    'EXCEPTION_THEME_SHOULD_BE_ONLY_IN_DATABASE' => 'Theme should not be defined in config.inc.php',
    'EMAIL_PRICEALARM_CUSTOMER_PRICEALARMIN'     => 'Price Alert in ',
    'EMAIL_PRICEALARM_CUSTOMER_HY'               => 'Hallo,',
    'EMAIL_PRICEALARM_CUSTOMER_HAVEPRICEALARM'   => 'we have a Price Alert in',
    'EMAIL_PRICEALARM_CUSTOMER_ITEM1'            => 'The Product',
    'EMAIL_PRICEALARM_CUSTOMER_ITEM2'            => "you're interested in and you offered a price of",
    'EMAIL_PRICEALARM_CUSTOMER_ITEM3'            => 'is now available for',
    'EMAIL_PRICEALARM_CUSTOMER_ITEM4'            => '!',
    'EMAIL_PRICEALARM_CUSTOMER_CLICKHERE1'       => 'To get directly to the product please click ',
    'EMAIL_PRICEALARM_CUSTOMER_CLICKHERE2'       => 'here',
    'EMAIL_PRICEALARM_CUSTOMER_TEAM1'            => 'Your',
    'EMAIL_PRICEALARM_CUSTOMER_TEAM2'            => 'Team',

    'IS_REVERSE_PROXY_AVAILABLE' => 'Test Reverse Proxy\'s availability',
    'REVERSE_PROXY_TEST_SUCCESS' => 'Reverse Proxy test succeed',
    'REVERSE_PROXY_TEST_FAILURE' => 'Reverse Proxy test failed',

    'SHOP_CONFIG_ADDITIONAL_SERVICE_VAT_CALCULATION_METHOD'       => 'VAT calculation of additional services',
    'SHOP_CONFIG_ADDITIONAL_SERVICE_VAT_CALCULATION_BIGGEST_NET'  => 'Calculate VAT according to the biggest net value',
    'SHOP_CONFIG_ADDITIONAL_SERVICE_VAT_CALCULATION_PROPORTIONAL' => 'Calculate VAT proportionately',

    'CUSTOM_TEMPLATE_EXIST_FOR_DELETED_SHOP' => 'Custom templates exist for deleted shop. Delete it manually if needed.',
    'TOTAL_PLUS_PROPORTIONAL_VAT'            => 'plus VAT (proportionally calculated)',

    'BUTTON_DOWNLOAD' => 'Download',

    'oxdiag_menu'             => 'Diagnostics tool',
    'OXDIAG_LIST_MENUITEM'    => 'Service',
    'OXDIAG_LIST_MENUSUBITEM' => 'Diagnostics tool',

    'OXDIAG_MAIN_TITLE'                              => 'Diagnostics of your OXID eShop',
    'OXDIAG_VERSIONCHECKER'                          => 'Version checker',
    'OXDIAG_INTROINFORMATION_CONTACT_US'             => 'You can contact us using',
    'OXDIAG_INTROINFORMATION_ONLINE_CONTACT_FORM'    => 'Online Contact Form',

    'OXDIAG_FORM_START_CHECK'    => 'Start diagnostics',

    'OXDIAG_RESULT_SUCCESSFUL'            => 'Diagnostics check successful.',
    'OXDIAG_RESULT'                       => 'Diagnostics check result',
    'OXDIAG_DOWNLOAD_FILE'                => 'Click here to download the result file',
    'OXDIAG_ERRORMESSAGETEMPLATE'         => 'These error(s) occured',
    'OXDIAG_VERSION'                      => 'Version',
    'OXDIAG_EDITION'                      => 'Edition',
    'OXDIAG_REVISION'                     => 'Revision',
    'OXDIAG_SUMMARY'                      => 'Summary',
    'OXDIAG_HINTS'                        => 'Hints',
    'OXDIAG_OK'                           => 'OK',
    'OXDIAG_MODIFIED'                     => 'Modified',
    'OXDIAG_VERSION_MISMATCH'             => 'Version mismatch',
    'OXDIAG_UNKNOWN'                      => 'Unknown',
    'OXDIAG_NUMBER_OF_INVESTIGATED_FILES' => 'Number of investigated files in total',
    'OXDIAG_SHOP_DOES_NOT_FIT'            => 'This OXID eShop does not fit 100%',
    'OXDIAG_SHOP_ORIGINAL'                => 'This OXID eShop was not modified and is fully original',

    'OXDIAG_MODIFIEDHINTS1'                       => 'OXID eShop has sophisticated possibility to extend it by modules without changing shipped files. It\'s not recommended and not needed to change shop files. See also our <a href="http://blog.oxid-esales.com/2009/02/how-extend-oxid-eshop-with-modules-part-1/" target=_blank>tutorials</a>.',
    'OXDIAG_MODIFIEDHINTS2'                       => 'Since OXID eShop 4.2.0 it\'s possible to use <a href="https://oxidforge.org/en/oxid-eshop-version-4-2-0.html#New_Features" target=_blank>your own templates without changing shipped ones</a>.',
    'OXDIAG_VERSIONMISMATCHHINTS'                 => 'Apparently one or more updates went wrong. See details link for more information about more details for each file. A left over file which is not any longer included in OXID eShop could also be a <u>possible</u> reason for version mismatch. Find information about update in our <a href="http://www.oxid-esales.com/en/support-services/documentation-and-help/oxid-eshop/installation/oxid-eshop-update-installation" target=_blank>Documentation and help</a>.',


    'OXDIAG_HOME'                     => 'OXID Diagnostics',
    'OXDIAG_ABOUT'                    => 'This Diagnostics tool collects technical information about your shop and server. This information might be useful before updating, installing modules or on diagnostics.',
    'OXDIAG_DOWNLOADLOG'              => 'Download report',

    //initial form
    'OXDIAG_COLLECT_MODULES'          => 'Fetch modules',
    'OXDIAG_COLLECT_HEALTH'           => 'Poll system health status',
    'OXDIAG_COLLECT_PHP'              => 'Poll PHP configuration (selected parameters)',
    'OXDIAG_COLLECT_SERVER'           => 'Poll system information (if possible)',
    'OXDIAG_STORE_ANALYSIS'           => 'Store results',
    'OXDIAG_COLLECT_START'            => 'Start analysis!',

    //index
    'OXDIAG_GOTO'                     => 'Go to',
    'OXDIAG_BASICS'                   => 'Basics',
    'OXDIAG_MODULES'                  => 'Modules',
    'OXDIAG_HEALTH'                   => 'System health',
    'OXDIAG_PHPINFO'                  => 'PHP information',
    'OXDIAG_SERVERINFO'               => 'Server information',
    'OXDIAG_RESTART'                  => 'Start new analysis',

    'OXDIAG_DISCL'                    => 'The analysis below the line has been stored in a report file.',
    'OXDIAG_HEALTH_OK'                => 'OK',
    'OXDIAG_HEALTH_MIN'               => 'MIN',
    'OXDIAG_HEALTH_FAIL'              => 'FAIL',

    //modules
    'OXDIAG_MODULES_STATE'            => 'Status',
    'OXDIAG_MODULES_NAME'             => 'Name',
    'OXDIAG_MODULES_ID'               => 'ID',
    'OXDIAG_MODULES_VERSION'          => 'Version',
    'OXDIAG_MODULES_VENDOR'           => 'Vendor',

    //php
    'OXDIAG_PHPINFO_EXTENSIONS'       => 'PHP extensions',
    'OXDIAG_PHPINFO_PARAM'            => 'Parameter',
    'OXDIAG_PHPINFO_VALUE'            => 'Value',
    'OXDIAG_PHPINFO_ZENDEX'           => 'Zend extension',
    'OXDIAG_PHPINFO_OFF'              => 'Off',

    //server
    'OXDIAG_SRVINF_NOTALL'            => 'Cannot request all values, due to disabled <i>exec</i> command on server.',
    'OXDIAG_SRVINF_NOTE'              => 'Note: This information is gathered for the current runtime frontend server. Should you have more than one frontend server running, you may access those directly in order to gather their information.',
    'OXDIAG_SERVERINFO_NOT_DETECTED'  => 'not detected',
    'OXDIAG_SERVERINFO_COMPONENT'     => 'Component',
    'SUBJECT_UNABLE_TO_SEND_VIA_CURL' => 'Information cannot be sent to OXID server via CURL',

    //final note
    'OXDIAG_FINALNOTE'                => 'End of analysis.',

    'OLC_ERROR_SERIAL_NOT_VALID'    => 'License key check failed. Try again or contact support if this occurs permanently.',
    'OLC_ERROR_RESPONSE_NOT_VALID'  => 'Error: service unavailable, try again later... If this persists, please check that your shop can make outgoing connections.',
    'OLC_ERROR_RESPONSE_UNEXPECTED' => 'Error: server response cannot be analyzed due to a not expected format. Please try again.',

    'VERSION_UPDATE_LINK' => 'http://www.oxid-esales.com/en/support-services/documentation-and-help/oxid-eshop/installation/oxid-eshop-update-installation/preparing-update.html',

    'ERROR_METADATA_CONTROLLERS_NOT_UNIQUE' => 'Error: Module not activated.<br />All controller keys and values must be unique throughout a shop or a sub-shop.<br />The following controller keys or values defined in metadata.php of this module are not unique:<br /> %s',

    'SHOP_CONFIG_FIELDS_CONTACTFORM' => 'Mandatory fields of the contact form',
    'EMAIL'                          => 'Email',
    'FIRST_NAME'                     => 'First name',
    'LAST_NAME'                      => 'Last name',
    'TITLE'                          => 'Salutation',
    'SUBJECT'                        => 'Subject',
    'MESSAGE'                        => 'Message',

];

/*
[{ oxmultilang ident='GENERAL_YOUWANTTODELETE'}]
*/
